<div class="text-sm mb-3">
    Showing <?php echo e($projects->firstItem()); ?> - <?php echo e($projects->lastItem()); ?> of <?php echo e($total_projects); ?> projects
</div>
<?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="flex bg-white rounded-lg shadow p-4 mb-5">
        <img src="<?php echo e($project->main_image_url); ?>" alt="<?php echo e($project->name); ?>" class="w-36 h-28 object-cover rounded mr-4" />
        <div class="flex-1">
            <div class="font-medium text-lg"><?php echo e($project->name); ?></div>
            <div class="text-gray-700 mb-1"><?php echo e($project->builder); ?> &middot; <?php echo e($project->city); ?></div>
            <div class="text-gray-500 text-sm mb-1">
                Configurations: <?php echo e($project->configurations); ?> |
                Status: <?php echo e($project->status); ?> |
                Possession: <?php echo e(\Carbon\Carbon::parse($project->possession_date)->format('Y')); ?>

            </div>
            <div class="text-gray-400 text-xs">Contact: <?php echo e($project->contact_phone); ?></div>
        </div>
        <div>
            <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('projects.show', $project->id)); ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Enquire</a>
            <?php else: ?>
                <button type="button" onclick="showLoginPopup()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Enquire</button>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="mt-6 bg-white p-8 rounded shadow text-center text-gray-600">
        No projects found for the selected filters.
    </div>
<?php endif; ?>

<div class="mt-6">
    <?php echo $projects->links(); ?>

</div>

<?php /**PATH /var/www/html/brick-website/resources/views/property/partials/project_list.blade.php ENDPATH**/ ?>