<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title><?php echo $__env->yieldContent('title', 'Bricklet - Real Estate Platform'); ?></title>
    
    <!-- Tailwind CSS -->
    <?php if(app()->environment('production')): ?>
    <link rel="stylesheet" href="<?php echo e(asset('build/assets/app.css')); ?>">
    <script src="<?php echo e(asset('build/assets/app.js')); ?>"></script>
	<?php else: ?>
	    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
	<?php endif; ?>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-50">
    <!-- Navigation Menu -->
    <?php echo $__env->make('partials.menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <!-- Page Content -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    
    <!-- Footer -->
    <footer class="bg-gray-800 text-white mt-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <div class="text-center">
                <p>&copy; <?php echo e(date('Y')); ?> Bricklet. All rights reserved.</p>
            </div>
        </div>
    </footer>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>

<?php /**PATH /var/www/html/brick-website/resources/views/layouts/guest.blade.php ENDPATH**/ ?>