<?php $__env->startSection('title', $property->title); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-10">
    
    <!-- Breadcrumb -->
    <div class="text-sm text-gray-500 mb-4">
        <a href="/" class="hover:text-blue-600">Home</a> /
        <a href="/properties" class="hover:text-blue-600">Properties</a> /
        <span class="text-gray-700"><?php echo e($property->title); ?></span>
    </div>

    <!-- Title & Address -->
    <div class="mb-6">
        <h1 class="text-2xl md:text-3xl font-semibold text-gray-900"><?php echo e($property->title); ?></h1>
        <p class="text-gray-600 mt-1"><?php echo e($property->address); ?>, <?php echo e($property->city); ?>, <?php echo e($property->state); ?> - <?php echo e($property->zip_code); ?></p>
    </div>

    <!-- Top Section -->
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
        <!-- Left: Gallery & Info -->
        <div class="lg:col-span-8 space-y-8">

            <!-- Image Slider -->
            <div class="relative">
                <div id="slider" class="relative overflow-hidden rounded-lg shadow-md">
                    <?php $__currentLoopData = ($property->images ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <img 
                            src="<?php echo e(asset('storage/'.$image)); ?>" 
                            class="slide w-full h-[400px] object-cover <?php echo e($index === 0 ? '' : 'hidden'); ?>" 
                            alt="Property Image"
                        >
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <button id="prev" class="absolute top-1/2 left-4 transform -translate-y-1/2 bg-white/70 hover:bg-white text-gray-700 p-2 rounded-full shadow">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </button>
                <button id="next" class="absolute top-1/2 right-4 transform -translate-y-1/2 bg-white/70 hover:bg-white text-gray-700 p-2 rounded-full shadow">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </button>
            </div>

            <!-- Price & Key Details -->
            <div class="grid grid-cols-2 md:grid-cols-3 gap-6 bg-gray-50 p-5 rounded-lg shadow-sm">
                <div>
                    <p class="text-gray-500 text-sm">Price</p>
                    <h3 class="text-lg font-semibold text-gray-900">₹<?php echo e(number_format($property->price)); ?></h3>
                </div>
                <div>
                    <p class="text-gray-500 text-sm">Type</p>
                    <h3 class="text-lg font-semibold text-gray-900"><?php echo e($property->property_type ?? 'N/A'); ?></h3>
                </div>
                <div>
                    <p class="text-gray-500 text-sm">Status</p>
                    <h3 class="text-lg font-semibold text-gray-900"><?php echo e(ucfirst(str_replace('_', ' ', $property->status))); ?></h3>
                </div>
            </div>

            <!-- Overview -->
            <section class="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                <h2 class="text-xl font-semibold text-gray-900 mb-3">Overview</h2>
                <p class="text-gray-700"><?php echo e($property->property_type ?? 'N/A'); ?></p>
            </section>

            <!-- Description -->
            <section class="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                <h2 class="text-xl font-semibold text-gray-900 mb-3">Description</h2>
                <p class="text-gray-700 leading-relaxed"><?php echo e($property->description); ?></p>
            </section>

            <!-- Features / Amenities -->
            <?php if(!empty($property->amenities)): ?>
            <section class="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Amenities</h2>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3 text-gray-700">
                    <?php $__currentLoopData = ($property->amenities ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center gap-2 text-sm bg-gray-50 p-2 rounded">
                            <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            <span><?php echo e($feature); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </section>
            <?php endif; ?>

            <!-- Comments -->
            <section class="bg-white p-6 rounded-lg shadow-sm border border-gray-100">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Comments</h2>
                <?php $__empty_1 = true; $__currentLoopData = $property->comments ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="border-b border-gray-100 pb-3 mb-3">
                        <div class="flex justify-between items-center mb-1">
                            <span class="font-semibold text-gray-800"><?php echo e($comment->user->name ?? 'Anonymous'); ?></span>
                            <span class="text-gray-500 text-xs"><?php echo e($comment->created_at->format('d M Y')); ?></span>
                        </div>
                        <p class="text-gray-700 text-sm"><?php echo e($comment->content); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-gray-600">No comments yet. Be the first to comment!</p>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <form action="<?php echo e(route('comments.store', $property->id)); ?>" method="POST" class="mt-4">
                        <?php echo csrf_field(); ?>
                        <textarea name="content" rows="3" placeholder="Write your comment..." class="w-full p-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500"></textarea>
                        <button type="submit" class="mt-3 bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition">Add Comment</button>
                    </form>
                <?php else: ?>
                    <p class="mt-4 text-sm text-gray-600">Please <a href="<?php echo e(route('login')); ?>" class="text-blue-600 underline">login</a> to add a comment.</p>
                <?php endif; ?>
            </section>
        </div>

        <!-- Sidebar -->
        <aside class="lg:col-span-4 space-y-6">
            <div class="bg-white p-6 rounded-lg shadow-sm border border-gray-100 sticky top-20">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Contact Agent</h3>
                <form action="" method="POST" class="space-y-3">
                    <?php echo csrf_field(); ?>
                    <input name="name" type="text" placeholder="Your Name" class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500">
                    <input name="email" type="email" placeholder="Email" required class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500">
                    <select name="interest" required class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500">
                        <option value="">Select inquiry type</option>
                        <option value="buy">Buy</option>
                        <option value="rent">Rent</option>
                        <option value="builder">Builder Property</option>
                    </select>
                    <button type="submit" class="w-full bg-green-600 text-white py-2 rounded-lg hover:bg-green-700 transition">Send Enquiry</button>
                    <button type="button" onclick="whatsappAgent()" class="w-full bg-green-500 text-white py-2 rounded-lg hover:bg-green-600 transition flex justify-center items-center gap-2">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M16.5 7.5c-.5-.5-1-1-1.5-1.5S13 5 12 5s-1 .5-1 1 .5 1 1 1c.1 0 .3 0 .5-.1.2.1.4.3.5.5.1.2.1.4 0 .5-.1.1-.4.1-.5 0-.1 0-.3 0-.5-.1s-.4-.5-1-.6-1-.1-1.5 0c-.5.1-1 .4-1.3.7-.3.4-.9 1.3-.9 2.2 0 .9 1 1.6 1 1.6s1.1.7 1.6.6c.5 0 1-.3 1.3-.7.3-.3.8-1.1.8-1.7s-.1-1.2-.6-1.7c-.3-.3-.7-.5-1-.5zM12 19c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7z"/></svg>
                        WhatsApp
                    </button>
                </form>
            </div>
        </aside>
    </div>
</div>

<script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('#slider .slide');

    document.getElementById('next')?.addEventListener('click', () => {
        slides[currentSlide].classList.add('hidden');
        currentSlide = (currentSlide + 1) % slides.length;
        slides[currentSlide].classList.remove('hidden');
    });

    document.getElementById('prev')?.addEventListener('click', () => {
        slides[currentSlide].classList.add('hidden');
        currentSlide = (currentSlide - 1 + slides.length) % slides.length;
        slides[currentSlide].classList.remove('hidden');
    });

    function whatsappAgent() {
        window.open('https://wa.me/919999999999?text=I%20am%20interested%20in%20<?php echo e(urlencode($property->title)); ?>', '_blank');
    }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/property/show.blade.php ENDPATH**/ ?>