<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-10">
    <h2 class="text-2xl font-bold mb-6">Search Results (<?php echo e($properties->total()); ?>)</h2>

    <form method="GET" action="<?php echo e(route('property.search')); ?>" class="mb-8 flex flex-wrap gap-4">
        <select name="property_type" class="border rounded px-3 py-2" value="<?php echo e($filters['property_type'] ?? ''); ?>">
            <option value="">All Types</option>
            <option value="buy" <?php echo e((isset($filters['property_type']) && $filters['property_type'] == 'buy') ? 'selected' : ''); ?>>Buy</option>
            <option value="rent" <?php echo e((isset($filters['property_type']) && $filters['property_type'] == 'rent') ? 'selected' : ''); ?>>Rent</option>
            <option value="commercial" <?php echo e((isset($filters['property_type']) && $filters['property_type'] == 'commercial') ? 'selected' : ''); ?>>Commercial</option>
        </select>

        <select name="city" class="border rounded px-3 py-2" value="<?php echo e($filters['city'] ?? ''); ?>">
            <option value="">All Cities</option>
            <option value="Guwahati" <?php echo e((isset($filters['city']) && $filters['city'] == 'Guwahati') ? 'selected' : ''); ?>>Guwahati</option>
            <option value="Mumbai" <?php echo e((isset($filters['city']) && $filters['city'] == 'Mumbai') ? 'selected' : ''); ?>>Mumbai</option>
            <option value="Delhi" <?php echo e((isset($filters['city']) && $filters['city'] == 'Delhi') ? 'selected' : ''); ?>>Delhi</option>
            <!-- Add your other cities here -->
        </select>

        <input type="text" name="q" class="border rounded px-3 py-2 flex-1" placeholder="Search..." value="<?php echo e($filters['q'] ?? ''); ?>" />

        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">Search</button>
    </form>

    <?php if($properties->count()): ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('property.show', $property->id)); ?>" class="bg-white rounded shadow hover:shadow-lg border overflow-hidden block no-underline text-inherit">
                    <img src="<?php echo e($property->main_image_url); ?>" class="h-40 w-full object-cover" />
                    <div class="p-4">
                        <div class="font-semibold text-lg truncate"><?php echo e($property->title); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e($property->city); ?>, <?php echo e($property->state); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e($property->bedrooms); ?> BHK · <?php echo e(ucfirst($property->type)); ?></div>
                        <div class="text-lg font-bold mt-1">₹<?php echo e(number_format($property->price)); ?></div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="mt-8">
            <?php echo e($properties->appends(request()->query())->links()); ?>

        </div>
    <?php else: ?>
        <p class="text-center text-gray-600 text-lg">No properties found matching your search criteria.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/property/search.blade.php ENDPATH**/ ?>