<?php $__env->startSection('title', 'Project - Bricklet'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header Section for Project Details Page -->
<div class="bg-white py-4 px-6 rounded-xl shadow mb-6 flex flex-col md:flex-row items-start md:items-center justify-between">
    <div>
        <h1 class="text-2xl md:text-3xl font-bold text-gray-800 mb-1"><?php echo e($project->name); ?></h1>
        <div class="text-gray-700 text-sm mb-1">by <?php echo e($project->builder); ?> &middot; <?php echo e($project->city); ?></div>
        <div class="text-lg md:text-xl text-blue-700 font-semibold mb-2">
            ₹<?php echo e(number_format($project->min_price)); ?> - ₹<?php echo e(number_format($project->max_price)); ?>

            <span class="text-base text-gray-600 pl-2">(<?php echo e($project->configurations); ?>)</span>
        </div>
        <?php if($project->approval_code): ?>
            <div class="bg-green-100 text-green-700 py-1 px-2 rounded text-xs inline-block">Approval: <?php echo e($project->approval_code); ?></div>
        <?php endif; ?>
    </div>
    <div class="mt-4 md:mt-0 flex flex-col gap-2">
        <a href="#contact"
           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded font-semibold text-center transition w-full md:w-auto">
            Contact Developer
        </a>
        <span class="text-gray-500 text-xs pt-2 md:pt-0">Possession: <?php echo e(\Carbon\Carbon::parse($project->possession_date)->format('M Y')); ?></span>
    </div>
</div>

<!-- Hero: Project Images Slider -->
<div class="mb-6">
    <!-- Swiper container -->
    <div class="swiper-container">
        <div class="swiper-wrapper">
            <?php $__empty_1 = true; $__currentLoopData = $project->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="swiper-slide">
                    <img src="<?php echo e($image->image_url); ?>" alt="Project Image" class="object-cover w-full h-64 rounded-lg" />
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="swiper-slide">
                    <img src="/default-image.jpg" alt="Default Project Image" class="object-cover w-full h-64 rounded-lg" />
                </div>
            <?php endif; ?>
        </div>
        <!-- Navigation buttons -->
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
        <!-- Pagination bullets -->
        <div class="swiper-pagination"></div>
    </div>
</div>

<!-- Info Highlights -->
<div class="grid grid-cols-2 md:grid-cols-5 gap-6 mb-8 text-center">
    <?php
    $highlights = [
        ['title' => 'Configurations', 'value' => $project->configurations, 'icon' => '🛏️'],
        ['title' => 'Possession Date', 'value' => \Carbon\Carbon::parse($project->possession_date)->format('M Y'), 'icon' => '📅'],
        ['title' => 'Status', 'value' => $project->status, 'icon' => '✅'],
        ['title' => 'Price Range', 'value' => "₹".number_format($project->min_price/100000, 2)." Cr - ₹".number_format($project->max_price/100000, 2)." Cr", 'icon' => '💰'],
        ['title' => 'RERA / Approval', 'value' => $project->approval_code, 'icon' => '🏛️'],
    ];
    ?>

    <?php $__currentLoopData = $highlights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="bg-white rounded-xl shadow-lg p-6 flex flex-col items-center justify-center transition transform hover:scale-105 group cursor-default">
        <div class="text-4xl mb-3 transition-colors group-hover:text-indigo-600"><?php echo e($highlight['icon']); ?></div>
        <h3 class="text-sm font-semibold text-gray-600 mb-1"><?php echo e($highlight['title']); ?></h3>
        <p class="text-lg font-semibold text-gray-900"><?php echo e($highlight['value']); ?></p>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<!-- Overview -->
<div class="bg-white rounded-xl shadow-lg p-8 mb-8">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        <!-- Quick Stats -->
        <div>
            <h2 class="text-3xl font-extrabold text-gray-900 mb-5 border-b-4 border-indigo-600 inline-block pb-1">Project Overview</h2>
            <p class="text-gray-700 leading-relaxed whitespace-pre-line text-lg"><?php echo e($project->overview); ?></p>
        </div>

        <!-- Builder, Contact & Location -->
        <div>
            <h2 class="text-3xl font-extrabold text-gray-900 mb-5 border-b-4 border-indigo-600 inline-block pb-1">Builder & Location</h2>
            <ul class="space-y-4 text-gray-700 text-lg font-medium">
                <li><span class="font-semibold text-indigo-600">Builder:</span> <?php echo e($project->builder); ?></li>
                <li><span class="font-semibold text-indigo-600">Location:</span> <?php echo e($project->location ?? $project->city); ?></li>
                <li><span class="font-semibold text-indigo-600">City:</span> <?php echo e($project->city); ?></li>
            </ul>
        </div>
    </div>
</div>


<!-- Price & Floor Plans Section -->
<div class="bg-white p-8 rounded-2xl shadow-lg mb-8">
    <h2 class="text-3xl font-extrabold mb-8 text-gray-900 border-b-4 border-indigo-500 inline-block pb-2">
        Price & Floor Plans
    </h2>
    
    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
        <?php $__currentLoopData = $project->floorPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-indigo-50 rounded-xl shadow-md p-6 flex flex-col cursor-default">
            <div class="text-indigo-700 font-semibold text-xl mb-2"><?php echo e($plan->config); ?></div>
            <div class="flex flex-wrap gap-4 mb-4">
                <div class="flex items-center gap-2 text-gray-600">
                    <!-- Area Icon -->
                    <svg class="w-5 h-5 text-indigo-500" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M8 21h8M12 3v18M4 10h16"></path>
                    </svg>
                    <span class="font-medium"><?php echo e($plan->area); ?> sq.ft</span>
                </div>
                <div class="flex items-center gap-2 text-gray-600">
                    <!-- Price Icon -->
                    <svg class="w-5 h-5 text-indigo-500" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10" />
                        <path d="M12 6v6l4 2" />
                    </svg>
                    <span class="font-medium">₹<?php echo e(number_format($plan->price)); ?></span>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<div class="w-full flex flex-col items-center justify-center gap-2 bg-white rounded-xl p-6 shadow">
  <h2 class="text-base font-medium text-center mb-2">EMI calculator</h2>

  <!-- Estimate summary -->
  <div class="flex flex-col gap-2 items-center justify-center mb-2">
    <div class="w-[300px] flex items-center justify-between px-2 py-2">
      <div class="flex-1 h-[2px] rounded-tr-md rounded-br-md bg-gradient-to-l from-black to-transparent"></div>
      <span class="px-4 bg-white text-xs leading-[140%] font-normal whitespace-nowrap">EMI ESTIMATE</span>
      <div class="flex-1 h-[2px] rounded-tl-md rounded-bl-md bg-gradient-to-r from-black to-transparent"></div>
    </div>
    <p class="text-2xl font-semibold text-black" id="emi-value">₹38,547 / month*</p>
    <p class="text-xs font-normal text-black" id="emi-summary">For 18 Years @ 9% | Total ₹95,64,152</p>
  </div>

  <h2 class="w-full text-xl py-2 font-medium text-left">EMI calculator</h2>
  <div class="w-full flex flex-col gap-4">

    <!-- Down Payment -->
    <div class="w-full flex flex-col gap-2">
      <div class="w-full flex items-center justify-between">
        <label class="font-medium text-black mb-2">Down payment*</label>
        <input class="w-24 outline-none px-2 py-2 bg-white border border-[#00000033] rounded-md text-sm font-medium" type="number" id="dp-input" value="1238000">
      </div>
      <input min="0" step="1000" class="w-full h-[6px] rounded-lg" type="range" id="dp-range" value="1238000" max="<?php echo e($project->max_price); ?>">
      <div class="w-full flex items-center justify-between">
        <span class="text-[#00000066] text-base font-medium">₹0</span>
        <span class="text-[#00000066] text-base font-medium">₹<?php echo e(number_format($project->max_price)); ?></span>
      </div>
    </div>

    <!-- Tenure -->
    <div class="w-full flex flex-col gap-2">
      <div class="w-full flex items-center justify-between">
        <label class="font-medium text-black mb-2">Tenure</label>
        <input class="w-16 outline-none px-2 py-2 bg-white border border-[#00000033] rounded-md text-sm font-medium" type="number" id="tenure-input" value="18">
      </div>
      <input min="1" max="35" step="1" class="w-full h-[6px] rounded-lg" type="range" id="tenure-range" value="18">
      <div class="w-full flex items-center justify-between">
        <span class="text-[#00000066] text-base font-medium">1 Year</span>
        <span class="text-[#00000066] text-base font-medium">35 Years</span>
      </div>
    </div>

    <!-- Interest -->
    <div class="w-full flex flex-col gap-2">
      <div class="w-full flex items-center justify-between">
        <label class="font-medium text-black mb-2">Interest</label>
        <input class="w-16 outline-none px-2 py-2 bg-white border border-[#00000033] rounded-md text-sm font-medium" type="number" id="rate-input" value="9">
      </div>
      <input min="0" max="15" step="0.1" class="w-full h-[6px] rounded-lg" type="range" id="rate-range" value="9">
      <div class="w-full flex items-center justify-between">
        <span class="text-[#00000066] text-base font-medium">0%</span>
        <span class="text-[#00000066] text-base font-medium">15%</span>
      </div>
    </div>
  </div>
  <p class="text-base w-full mt-2 font-medium text-left text-[#00000066]">
    *Final EMI gets calculated after income verification.
  </p>
</div>


<!-- Amenities Section -->
<div class="bg-white rounded-xl shadow-lg p-8 mb-8">
    <h2 class="text-3xl font-extrabold text-gray-900 mb-8 border-b-4 border-indigo-600 inline-block pb-2">
        Project Amenities
    </h2>
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
        <?php $__currentLoopData = $project->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center gap-3 p-3 rounded-lg border border-gray-200 hover:bg-indigo-50 transition cursor-pointer">
                <div class="text-indigo-600 text-2xl">
                    <!-- Example icon, replace with actual icons per amenity if available -->
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 8c1.66 0 3-1.34 3-3S13.66 2 12 2 9 3.34 9 5s1.34 3 3 3zM18.36 8.64a7.5 7.5 0 01-.82 1.53c-1.07 1.68-3.62 3.55-7.54 2.54-4.09-1.05-7.35-4.68-6.25-9.03" />
                    </svg>
                </div>
                <p class="text-gray-700 font-semibold text-lg"><?php echo e($amenity->amenity); ?></p>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<!-- Reviews Section -->
<div class="bg-white rounded-xl shadow-lg p-8 mb-8">
    <h2 class="text-3xl font-extrabold text-gray-900 mb-6 border-b-4 border-indigo-600 inline-block pb-2">
        Ratings & Reviews
    </h2>

    <!-- Display Reviews -->
    <div class="space-y-6 mb-8 max-h-96 overflow-y-auto">
        <?php $__empty_1 = true; $__currentLoopData = $project->reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border rounded-lg p-4 shadow-sm">
                <div class="text-sm font-semibold text-indigo-700 mb-1"><?php echo e($review->user?->name ?? 'Anonymous'); ?></div>
                <div class="flex items-center mb-2">
                    <?php for($i = 1; $i <= 5; $i++): ?>
                        <svg class="w-5 h-5 inline <?php echo e($i <= round($review->rating) ? 'text-yellow-400' : 'text-gray-300'); ?>" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927C9.349 2.329 10.651 2.329 10.951 2.927l1.286 2.6 2.88.42c.678.1.95.93.456 1.414l-2.085 2.03.492 2.873c.117.68-.614 1.198-1.224.88l-2.568-1.35-2.568 1.35c-.61.318-1.34-.2-1.224-.88l.492-2.873-2.085-2.03c-.494-.484-.222-1.314.456-1.414l2.88-.42 1.286-2.6z" />
                        </svg>
                    <?php endfor; ?>
                </div>
                <p class="text-gray-700"><?php echo e($review->text); ?></p>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-gray-500">No reviews yet.</p>
        <?php endif; ?>
    </div>

    <!-- Review Submission Form -->
    <?php if(auth()->guard()->check()): ?>
    <form action="<?php echo e(route('project.review.submit', $project->id)); ?>" method="POST" class="space-y-4 max-w-lg">
        <?php echo csrf_field(); ?>
        <h3 class="text-xl font-semibold mb-2">Add Your Review</h3>
        <div>
            <label for="rating" class="block font-medium mb-1">Rating</label>
            <select id="rating" name="rating" class="w-full border rounded p-2">
                <?php for($i = 5; $i >= 1; $i--): ?>
                    <option value="<?php echo e($i); ?>"><?php echo e($i); ?> Star<?php echo e($i > 1 ? 's' : ''); ?></option>
                <?php endfor; ?>
            </select>
        </div>
        <div>
            <label for="text" class="block font-medium mb-1">Review</label>
            <textarea id="text" name="text" rows="4" class="w-full border rounded p-2" placeholder="Write your review here..."></textarea>
        </div>
        <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded font-semibold hover:bg-indigo-700 transition">
            Submit Review
        </button>
    </form>
    <?php else: ?>
        <div class="bg-yellow-100 border-l-4 border-yellow-400 p-4 text-yellow-700 max-w-lg mx-auto rounded">
            <p>Please <a href="<?php echo e(route('login')); ?>" class="underline font-semibold">log in</a> to submit a review.</p>
        </div>
    <?php endif; ?>
</div>

<!-- Brochure Section -->
<div class="bg-white rounded-xl shadow-lg p-8 mb-8">
    <h2 class="text-3xl font-extrabold text-gray-900 mb-6 border-b-4 border-indigo-600 inline-block pb-2">
        Project Brochure
    </h2>

    <?php if($project->brochure_url): ?>
    <div class="flex items-center gap-6">
        <a href="<?php echo e($project->brochure_url); ?>" target="_blank"
           class="inline-flex items-center px-6 py-3 bg-indigo-600 hover:bg-indigo-700 text-white font-semibold rounded-lg shadow transition">
            Download Brochure
            <svg class="ml-2 w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 4v16m8-8H4"></path>
            </svg>
        </a>

        <iframe src="<?php echo e($project->brochure_url); ?>" class="flex-1 h-64 rounded-lg border" frameborder="0"></iframe>
    </div>
    <?php else: ?>
    <p class="text-gray-500">Brochure not available for this project.</p>
    <?php endif; ?>
</div>

<!-- Miscellaneous Widgets Section -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
    <!-- FAQ Widget -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h3 class="text-xl font-bold mb-4 text-indigo-700">Frequently Asked Questions</h3>
        <ul class="list-disc pl-5 space-y-2 text-gray-700 text-sm">
            <li>What is the project possession date?</li>
            <li>Are there any maintenance fees?</li>
            <li>What amenities are included?</li>
            <li>How to book a site visit?</li>
            <!-- Add dynamic FAQs if available -->
        </ul>
    </div>

    <!-- Neighbourhood Widget -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h3 class="text-xl font-bold mb-4 text-indigo-700">Neighbourhood</h3>
        <p class="text-gray-700 text-sm mb-4">Explore schools, hospitals, shopping, and more near the project.</p>
        <a href="https://maps.google.com/?q=<?php echo e($project->latitude); ?>,<?php echo e($project->longitude); ?>" target="_blank" class="text-indigo-600 hover:text-indigo-800 underline">
            View on Google Maps
        </a>
    </div>

    <!-- Helpful Tools Widget -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h3 class="text-xl font-bold mb-4 text-indigo-700">Helpful Tools</h3>
        <ul class="space-y-3 text-gray-700 text-sm">
            <li><a href="#" class="hover:underline">EMI Calculator</a></li>
            <li><a href="#" class="hover:underline">Affordability Calculator</a></li>
            <li><a href="#" class="hover:underline">Eligibility Calculator</a></li>
        </ul>
    </div>
</div>

<!-- Neighbourhood Map -->
<div id="map" class="w-full h-80 rounded-xl shadow-lg mb-8"></div>

<script>
    function initMap() {
        const location = { lat: <?php echo e($project->latitude); ?>, lng: <?php echo e($project->longitude); ?> };
        const map = new google.maps.Map(document.getElementById('map'), {
            center: location,
            zoom: 14,
            styles: [ /* Optional: add custom style JSON here */ ]
        });
        new google.maps.Marker({
            position: location,
            map: map,
            title: '<?php echo e($project->name); ?>'
        });
    }
</script>

<script async defer src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&callback=initMap"></script>

<?php $__env->stopSection(); ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css"/>
<script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    var swiper = new Swiper('.swiper-container', {
      loop: true,
      navigation: {
         nextEl: '.swiper-button-next',
         prevEl: '.swiper-button-prev',
      },
      pagination: {
         el: '.swiper-pagination',
         clickable: true,
      },
    });
  });
</script>
<script>
function calculateEMI(principal, rate, years) {
  var n = years * 12;
  var r = rate / 12 / 100;
  var emi = principal * r * Math.pow(1 + r, n) / (Math.pow(1 + r, n) - 1);
  var totalPay = emi * n;
  return {emi: Math.round(emi), total: Math.round(totalPay)};
}

function updateEMI() {
  let dp = Number(document.getElementById('dp-input').value) || 0;
  let years = Number(document.getElementById('tenure-input').value) || 1;
  let rate = Number(document.getElementById('rate-input').value) || 0;

  let result = calculateEMI(dp, rate, years);
  document.getElementById('emi-value').innerText = '₹' + result.emi.toLocaleString('en-IN') + ' / month*';
  document.getElementById('emi-summary').innerText =
    `For ${years} Years @ ${rate}% | Total ₹${result.total.toLocaleString('en-IN')}`;
}

document.addEventListener('DOMContentLoaded', function () {
['dp-input','tenure-input','rate-input','dp-range','tenure-range','rate-range'].forEach(id => {
  document.getElementById(id).addEventListener('input', function(e) {
    if(id.endsWith('-range')) {
      document.getElementById(id.replace('-range','-input')).value = e.target.value;
    } else {
      document.getElementById(id.replace('-input','-range')).value = e.target.value;
    }
    updateEMI();
  });
});
});

updateEMI();
</script>



<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/projects/show.blade.php ENDPATH**/ ?>