<div class="text-sm mb-3">
    Showing <?php echo e($properties->firstItem()); ?> - <?php echo e($properties->lastItem()); ?> of <?php echo e($total_properties); ?> properties
</div>
<?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="flex bg-white rounded-lg shadow p-4 mb-5">
        <img src="<?php echo e($property->main_image_url); ?>" alt="<?php echo e($property->title); ?>" class="w-36 h-28 object-cover rounded mr-4" />
        <div class="flex-1">
            <div class="font-medium text-lg"><?php echo e($property->title); ?></div>
            <div class="text-gray-700 mb-1">₹<?php echo e(number_format($property->price)); ?> | <?php echo e($property->area); ?> sq.ft | <?php echo e(ucfirst($property->furnishing)); ?></div>
            <div class="text-gray-500 text-sm mb-1">Amenities: <?php echo e($property->amenities); ?></div>
            <div class="text-gray-400 text-xs">Listed by <?php echo e($property->listed_by); ?></div>
        </div>
        <div>
            <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('properties.show', $property->id)); ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Contact</a>
            <?php else: ?>
                <button type="button" onclick="showLoginPopup()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Contact</button>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="mt-6 bg-white p-8 rounded shadow text-center text-gray-600">
        No properties found for the selected filters.
    </div>
<?php endif; ?>

<div class="mt-6">
    <?php echo $properties->links(); ?>

</div>

<?php /**PATH /var/www/html/brick-website/resources/views/property/partials/sale_list.blade.php ENDPATH**/ ?>