<?php $__env->startSection('title', 'For Sale - Bricklet'); ?>

<?php $__env->startSection('content'); ?>

<div class="bg-gray-100 py-6 min-h-screen">
    <div class="max-w-7xl mx-auto px-4">
        <!-- Filters -->
        <form id="filterSaleForm" class="flex flex-wrap gap-4 bg-white p-4 rounded-lg shadow mb-6">
            <select name="bhk_type" class="border rounded px-3 py-2">
                <option value="">BHK Type</option>
                <option value="1">1 BHK</option>
                <option value="2">2 BHK</option>
                <option value="3">3 BHK</option>
            </select>
            <select name="price_range" class="border rounded px-3 py-2">
                <option value="">Price Range</option>
                <option value="0-3000000">₹0 - ₹30L</option>
                <option value="3000001-5000000">₹30L - ₹50L</option>
                <option value="5000001-10000000">₹50L+</option>
            </select>
            <select name="furnishing" class="border rounded px-3 py-2">
                <option value="">Furnishing</option>
                <option value="Fully">Fully Furnished</option>
                <option value="Semi">Semi Furnished</option>
                <option value="Unfurnished">Unfurnished</option>
            </select>
            <select name="property_type" class="border rounded px-3 py-2">
                <option value="">Property Type</option>
                <option value="Apartment">Apartment</option>
                <option value="House">House</option>
            </select>
            <button type="submit" class="ml-auto bg-blue-600 text-white px-4 py-2 rounded">Apply Filters</button>
        </form>

        <!-- Listings & Sidebar -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Listings Left -->
            <div class="md:col-span-2" id="listingSaleArea">
                <?php echo $__env->make('property.partials.sale_list', ['properties' => $properties, 'total_properties' => $total_properties], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            <!-- Sidebar/ad -->
            <aside class="md:col-span-1 flex flex-col gap-5">
                <div class="bg-white p-5 rounded-lg shadow text-center"> ... </div>
                <div class="bg-white p-5 rounded-lg shadow text-center"> ... </div>
            </aside>
        </div>
    </div>
</div>

<div id="loginModal" class="fixed inset-0 bg-black bg-opacity-40 z-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg p-8 shadow-lg w-full max-w-md text-center">
        <h3 class="text-xl font-bold mb-4 text-gray-900">Sign in to continue</h3>
        <p class="text-gray-700 mb-6">To like or save a property, please login or register for free.</p>
        <a href="<?php echo e(route('login')); ?>" class="bg-blue-600 text-white font-semibold px-6 py-2 rounded mr-2 hover:bg-blue-700 transition">Login</a>
        <a href="<?php echo e(route('register')); ?>" class="bg-gray-100 text-blue-600 font-semibold px-6 py-2 rounded hover:bg-gray-200 transition">Register</a>
        <button onclick="closeLoginPopup()" class="block mt-8 text-gray-500 hover:text-gray-800 mx-auto">Close</button>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
function closeLoginPopup() {
        document.getElementById('loginModal').classList.add('hidden');
    }
$('#filterSaleForm').on('submit', function(e){
    e.preventDefault();
    var $form = $(this);
    $.get("<?php echo e(route('properties.sale')); ?>", $form.serialize(), function(data){
        $('#listingSaleArea').html(data);
    });
});
$(document).on('click', '#listingSaleArea .pagination a', function(e){
    e.preventDefault();
    var url = $(this).attr('href');
    $.get(url, $('#filterSaleForm').serialize(), function(data){
        $('#listingSaleArea').html(data);
    });
});
window.showLoginPopup = function() {
    $('#loginModal').removeClass('hidden');
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/property/sale.blade.php ENDPATH**/ ?>