<?php $__env->startSection('title', 'About Us - Bricklet'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen py-12 px-4">
    <div class="max-w-2xl mx-auto">
        <!-- Hero Section -->
        <section class="mb-10 text-center">
            <h1 class="text-4xl font-extrabold text-blue-900 mb-3">Warehouse Construction</h1>
            <p class="text-lg text-gray-700 mb-4">
                Why choose <span class="font-semibold text-blue-800">BRICKLET</span> for Warehouse Construction?
            </p>
            <ul class="text-left space-y-3 mb-6 max-w-lg mx-auto">
                <li>✔ Customized Solutions: Warehouse designs tailored to your storage, logistics, and operational needs.</li>
                <li>✔ Strategic Locations: Warehouses built in prime locations for top connectivity and accessibility.</li>
                <li>✔ High-Quality Materials: Only premium construction materials for long-term durability and sustainability.</li>
                <li>✔ Compliance & Safety: Adherence to all regulations and standards for a secure work environment.</li>
                <li>✔ Fast & Efficient Execution: Timely project completion, no compromise on quality.</li>
            </ul>
        </section>

        <!-- Services Section -->
        <section class="mb-10">
            <h2 class="text-xl font-bold text-blue-900 mb-4">Our Warehouse Construction Services</h2>
            <ul class="list-disc pl-5 space-y-2 text-gray-800">
                <li>🔹 Turnkey Warehouse Development – End-to-end management: design to handover.</li>
                <li>🔹 Industrial & Logistics Warehouses – Built for manufacturing and supply chain solutions.</li>
                <li>🔹 Warehouse Expansion & Renovation – Upgrade and expand infrastructure for scaling business needs.</li>
            </ul>
        </section>

        <!-- Call to Action -->
        <section class="bg-blue-100 rounded-xl shadow p-6 text-center mb-8">
            <h3 class="text-lg font-semibold text-blue-900 mb-2">Get Started with BRICKLET</h3>
            <p class="text-gray-800 mb-2">Looking for a reliable partner for your warehouse construction project? BRICKLET is here to turn your vision into reality. Contact us today for tailored solutions to fit your business needs.</p>
            <div class="mt-4 flex flex-col items-center space-y-2">
                <div class="flex items-center gap-2 text-blue-800 font-medium">
                    <svg class="w-5 h-5" stroke="currentColor" fill="none" viewBox="0 0 24 24"><path d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10z"/><path d="M15 12h-3V7"/></svg>
                    <span>Call us at: <a href="tel:9395575146" class="underline font-bold">93955 75146</a></span>
                </div>
                <div class="flex items-center gap-2 text-blue-800 font-medium">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M3 8l7.89 5.26a2 2 0 0 0 2.22 0L21 8"/><rect x="2" y="6" width="20" height="12" rx="2"/></svg>
                    <span>Email us at: <a href="mailto:contact@bricklet.in" class="underline font-bold">contact@bricklet.in</a></span>
                </div>
                <div class="flex items-center gap-2 text-blue-800 font-medium">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10"/></svg>
                    <span>Visit us at: <a href="https://bricklet.in" class="underline font-bold" target="_blank">bricklet.in</a></span>
                </div>
            </div>
        </section>

        <!-- Inquiry Form -->
        <section class="bg-white rounded-lg shadow py-8 px-6">
            <h2 class="text-lg font-bold text-blue-900 mb-4">Tell us about your project</h2>
            <form class="space-y-4">
                <div class="grid grid-cols-2 gap-4">
                    <input type="text" name="first" placeholder="First Name" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                    <input type="text" name="last" placeholder="Last Name" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                </div>
                <input type="email" name="email" placeholder="Email" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                <input type="text" name="phone" placeholder="Phone Number" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                <select name="design_type" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200">
                    <option value="">What do you want to design?</option>
                    <option value="Turnkey Warehouse Development">Turnkey Warehouse Development</option>
                    <option value="Industrial & Logistics Warehouses">Industrial & Logistics Warehouses</option>
                    <option value="Renovation & Expansion">Warehouse Renovation & Expansion</option>
                </select>
                <button type="submit" class="w-full bg-blue-700 text-white py-2 rounded font-semibold hover:bg-blue-800 transition">Submit</button>
            </form>
        </section>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/services/warehouse-construction.blade.php ENDPATH**/ ?>