<?php $__env->startSection('title', 'About Us - Bricklet'); ?>

<?php $__env->startSection('content'); ?>

<div class="bg-gray-50 min-h-screen py-12 px-4">
    <div class="max-w-4xl mx-auto">
        <!-- Hero Section -->
        <section class="text-center mb-10">
            <h1 class="text-4xl font-extrabold text-blue-900 mb-3">Architech & Interior Design</h1>
            <p class="text-lg text-gray-700 max-w-2xl mx-auto mb-4">
                We are a multifaceted infrastructure projects and designing firm, delivering integrated turnkey solutions to diversified sectors in construction planning and design enabling our clients achieve desired results across our service domains.
            </p>
            <p class="text-base italic text-blue-700 mb-2">VISION: To be the preferred infrastructure projects and designing consulting firm delivering quality solutions to our esteemed clients</p>
        </section>

        <!-- What we do & Services -->
        <section class="mb-10 grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
                <h2 class="font-semibold text-blue-900 text-xl mb-3">What we do</h2>
                <ul class="space-y-2 pl-5 text-gray-800">
                    <li>Architecture</li>
                    <li>Master Planning</li>
                    <li>Design &amp; Build</li>
                    <li>Interior Design</li>
                </ul>
            </div>
            <div>
                <h2 class="font-semibold text-blue-900 text-xl mb-3">Project Classification</h2>
                <ul class="space-y-2 pl-5 text-gray-800">
                    <li>2D Design &amp; Planning</li>
                    <li>3D Design &amp; Planning</li>
                    <li>Interior Design</li>
                    <li>Modular Kitchen</li>
                </ul>
            </div>
        </section>

        <!-- Project Gallery -->
        <section class="mb-12">
            <h2 class="text-2xl font-bold text-blue-900 mb-4">Some of Our Projects</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                <div>
                    <h3 class="font-semibold text-blue-800 mb-2">Architectural Designs</h3>
                    <div class="grid grid-cols-2 gap-3">
                        <img src="/images/L3D557S14ENDP2CR7FIUWJTCWLUF3P3WA888_1024x768.jpg" alt="3D Project" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2022-12-03.jpg" alt="Project Sample" class="rounded shadow" />
                    </div>
                </div>
                <div>
                    <h3 class="font-semibold text-blue-800 mb-2">Interior Designs with 3D Designs</h3>
                    <div class="mb-2 font-medium text-gray-700">Living Room</div>
                    <div class="grid grid-cols-3 gap-2">
                        <img src="/images/WhatsApp-Image-2023-12-30-AM7.jpg" alt="Living Room 3D" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2023-12-30-AM8.jpg" alt="Living Room Sample" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2023-12-30-AM3.jpg" alt="Living Room Angle" class="rounded shadow" />
                    </div>
                    <div class="mt-4 font-medium text-gray-700">Bedroom</div>
                    <div class="grid grid-cols-2 gap-2">
                        <img src="/images/WhatsApp-Image-2023-12-30-AM2.jpg" alt="Bedroom" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2023-12-30-AM5.jpg" alt="Bedroom" class="rounded shadow" />
                    </div>
                    <div class="mt-4 font-medium text-gray-700">Dining Area</div>
                    <div class="grid grid-cols-2 gap-2">
                        <img src="/images/WhatsApp-Image-2023-12-30-AM11.jpg" alt="Dining" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2023-12-30-AM3.jpg" alt="Dining" class="rounded shadow" />
                    </div>
                    <div class="mt-4 font-medium text-gray-700">Kitchen</div>
                    <div class="grid grid-cols-3 gap-2">
                        <img src="/images/WhatsApp-Image-2023-12-30-AM7.jpg" alt="Kitchen" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2023-12-30-AM1.jpg" alt="Kitchen" class="rounded shadow" />
                        <img src="/images/WhatsApp-Image-2023-12-30-AM16.jpg" alt="Kitchen" class="rounded shadow" />
                    </div>
                </div>
            </div>
        </section>

        <!-- Inquiry Form -->
        <section class="bg-white rounded-lg shadow py-8 px-6 max-w-2xl mx-auto">
            <h2 class="text-xl font-bold text-blue-900 mb-4">Yours Design, Our 3D Magic</h2>
            <form class="space-y-4">
                <div class="grid grid-cols-2 gap-4">
                    <input type="text" name="first" placeholder="First Name" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                    <input type="text" name="last" placeholder="Last Name" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                </div>
                <input type="email" name="email" placeholder="Email" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                <input type="text" name="phone" placeholder="Phone Number" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                <select name="design_type" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200">
                    <option value="">What do you want to design?</option>
                    <option value="Architecture">Architecture</option>
                    <option value="Master Planning">Master Planning</option>
                    <option value="Design & Build">Design & Build</option>
                    <option value="Interior Design">Interior Design</option>
                    <option value="Modular Kitchen">Modular Kitchen</option>
                </select>
                <button type="submit" class="w-full bg-blue-700 text-white py-2 rounded font-semibold hover:bg-blue-800 transition">Submit</button>
            </form>
        </section>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/services/architech.blade.php ENDPATH**/ ?>