<?php $__env->startSection('title', 'About Us - Bricklet'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-[#fafbfc] min-h-screen py-8 px-1">
  <div class="max-w-3xl mx-auto space-y-10">

    <!-- Land/Plot Section 1 -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/Vaastu-Tips-for-Buying-a-Plot-584x438.png.webp" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Land Plot" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu Sashtra – Land & plot Situation of Plot</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1 mb-2">
          <li>Avoid plots with cut/irregular L corners or axis extensions.</li>
          <li>Obstructions like tall buildings, towers in the north, northeast aren’t good for vastu-agri and new developments.</li>
          <li>Always choose the site with a water source, well, or entrance in the northeast for maximum positivity.</li>
          <li>A water source in the northeast is ideal; avoid northwest, south, southeast.</li>
          <li>The northeast should be slightly lower than south and west. North and east should be lower than south and west at the compound level.</li>
        </ul>
      </div>
    </section>

    <!-- Entrance/Main Door -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/maindoor-584x438.jpg" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Entrance" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Entrance and Main Door</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li><strong>Main door:</strong> should be in east, north or northeast, and should be the biggest and most beautiful door.</li>
          <li>Doors should open clockwise and be noise-free.</li>
          <li>There should not be any toilet, staircase, pillar or duct in front of the entrance.</li>
          <li>Main entrance should not face another building’s main gate directly.</li>
        </ul>
      </div>
    </section>

    <!-- Bedroom -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/istockphoto-1213695547-612x612-1-584x367.jpg.webp" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Bedroom" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Bedroom</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li><strong>Master bedroom:</strong> should be in southwest or northwest. Don’t use upper floors for master bedroom in duplexes/villas.</li>
          <li><strong>Children’s bedroom:</strong> should be in northeast or west, young children can use east or northeast.</li>
          <li>Never maintain couple’s/child’s bedroom side by side on the outside.</li>
          <li>Bed location: south-west and never positioned under a beam.</li>
          <li>Mirror shouldn’t reflect the bed or show any clutter or washroom/commode.</li>
        </ul>
      </div>
    </section>

    <!-- Mirror -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/Mirror_Vastu-480x438.jpeg" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Mirror" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Mirror</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li>Mirrors should not directly face the bed or the restroom.</li>
          <li>Best placement: east or north walls; not west and never on main entry wall.</li>
        </ul>
      </div>
    </section>

    <!-- Living Room -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/Open-upthe-Wall-2-584x438.jpg" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Living Room Vastu" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Living or Sitting Room</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li>Location: north or northeast side preferred.</li>
          <li>Furniture: square or rectangle shapes are best.</li>
          <li>Art and decor: placement on east, north or east walls is positive.</li>
        </ul>
      </div>
    </section>

    <!-- TV Section -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/WhatsApp-Image-2024-05-28-at-12.33.29-AM-584x438.jpeg.webp" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Television" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Television</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li>Best placement: TV in southeast or northwest or in the living room.</li>
          <li>Avoid placing TV in the northeast corner.</li>
          <li>TV should not directly face a door or window.</li>
        </ul>
      </div>
    </section>

    <!-- Dining Room -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/dining-room-ideas-1252-005-1621977481-584x438.jpg.webp" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Dining Room" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Dining Room</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li>Preferred location: east, west, or northeast.</li>
          <li>Dining table: square or round, never odd-shaped.</li>
          <li>Wash basin: should be in the north, east, or northwest.</li>
        </ul>
      </div>
    </section>

    <!-- Toilet/Bath Section -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/steven-ungermann-1AF5hP6F4tI-unsplash-584x438.jpg.webp" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu Bathroom/Toilet" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu Toilet and Bathroom</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li>Bathrooms should be wet areas—north and east are best; avoid center or southwest.</li>
          <li>Toilets should not be north or northeast, best in northwest/west.</li>
          <li>Keep toilet doors closed when not in use.</li>
        </ul>
      </div>
    </section>

    <!-- Office Section -->
    <section class="flex flex-col md:flex-row items-start gap-6 bg-white rounded-xl shadow p-6">
      <img src="/images/alesia-kazantceva-XLm6-fPwK5Q-unsplash-584x438.jpg.webp" class="h-36 w-full md:w-44 object-cover rounded-lg shadow" alt="Vastu for Office" />
      <div>
        <h2 class="text-base md:text-lg font-bold mb-2">Vastu for Office</h2>
        <ul class="list-disc pl-5 text-[15px] text-gray-700 space-y-1">
          <li>Site selection: Choose plot facing east, north, or northeast.</li>
          <li>Main entrance: ideally to the east or north.</li>
          <li>Staff seated north, boss table facing east, seat in southwest or northwest preferred.</li>
        </ul>
      </div>
    </section>

    <!-- Contact Form -->
    <section class="bg-white rounded-lg shadow py-8 px-6 mt-10">
        <h2 class="text-lg font-bold text-blue-900 mb-4">Vastu Help / Inquiry</h2>
        <form class="space-y-3">
            <div class="grid grid-cols-2 gap-3">
                <input type="text" name="first" placeholder="First Name" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
                <input type="text" name="last" placeholder="Last Name" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
            </div>
            <input type="email" name="email" placeholder="Email" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
            <input type="text" name="phone" placeholder="Phone Number" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
            <input type="text" name="design_query" placeholder="What did you want to design?" class="px-3 py-2 border rounded w-full focus:ring focus:ring-blue-200" />
            <button type="submit" class="w-full bg-blue-700 text-white py-2 rounded font-semibold hover:bg-blue-900 transition">Submit</button>
        </form>
    </section>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/services/vastu-shastra.blade.php ENDPATH**/ ?>