<?php $__env->startSection('title', $property->title . ' - RealtyCo'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-6 py-12">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">

        <!-- Image Gallery -->
        <div class="lg:col-span-2">
            <div class="relative w-full h-96 rounded-lg overflow-hidden shadow-lg">
                <img src="<?php echo e($property->main_image_url); ?>" alt="<?php echo e($property->title); ?>" class="w-full h-full object-cover">
                <!-- TODO: Add slider arrows / thumbnails -->
            </div>
            <div class="mt-4 grid grid-cols-4 gap-4">
                <?php $__currentLoopData = $property->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <img src="<?php echo e($image->url); ?>" alt="<?php echo e($property->title); ?>" class="w-full h-24 object-cover rounded cursor-pointer hover:ring-2 hover:ring-blue-600" onclick="document.querySelector('.relative.w-full').firstElementChild.src='<?php echo e($image->url); ?>'">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Property Summary and Actions -->
        <div class="space-y-6">
            <h1 class="text-3xl font-bold text-gray-900"><?php echo e($property->title); ?></h1>
            <p class="text-gray-600"><?php echo e($property->location); ?></p>
            <p class="text-blue-600 text-3xl font-extrabold"><?php echo e($property->price_display); ?></p>

            <div class="flex flex-wrap gap-4 text-gray-700">
                <div class="flex items-center gap-2">
                    <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M8 7v10l5-5-5-5z"/></svg>
                    <span><?php echo e($property->bedrooms); ?> Beds</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M12 7v10"/></svg>
                    <span><?php echo e($property->bathrooms); ?> Baths</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M3 7h18"/></svg>
                    <span><?php echo e($property->area); ?> sqft</span>
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex flex-col space-y-4 sm:flex-row sm:space-y-0 sm:space-x-4">
                <?php if(auth()->guard()->check()): ?>
                    <button class="flex-1 bg-blue-600 text-white font-bold py-3 rounded hover:bg-blue-700 transition" onclick="contactAgent(<?php echo e($property->agent_id); ?>)">Contact Agent</button>
                    <button class="flex-1 border border-blue-600 text-blue-600 font-semibold py-3 rounded hover:bg-blue-50 transition" onclick="scheduleVisit(<?php echo e($property->id); ?>)">Schedule Visit</button>
                <?php else: ?>
                    <button class="flex-1 bg-blue-600 text-white font-bold py-3 rounded hover:bg-blue-700 transition" onclick="showLoginPrompt()">Contact Agent</button>
                    <button class="flex-1 border border-blue-600 text-blue-600 font-semibold py-3 rounded hover:bg-blue-50 transition" onclick="showLoginPrompt()">Schedule Visit</button>
                <?php endif; ?>
            </div>

            <!-- Description -->
            <section>
                <h2 class="text-xl font-semibold text-gray-900 mb-2">About this Property</h2>
                <p class="text-gray-700 whitespace-pre-line"><?php echo e($property->description); ?></p>
            </section>

            <!-- Amenities -->
            <?php if($property->amenities->count()): ?>
            <section class="mt-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Amenities</h2>
                <ul class="grid grid-cols-2 sm:grid-cols-3 gap-4 text-gray-700">
                    <?php $__currentLoopData = $property->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                            <span><?php echo e($amenity->name); ?></span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </section>
            <?php endif; ?>

        </div>
    </div>
</div>

<script>
    function showLoginPrompt() {
        // Show login popup modal similar to previous code
        // For example:
        document.getElementById('login-popup').classList.remove('hidden');
    }
    function contactAgent(agentId) {
        // Implement contact agent logic here or redirect to contact form
        alert('Contact agent: ' + agentId);
    }
    function scheduleVisit(propertyId) {
        // Redirect or show a form to schedule a visit
        alert('Schedule visit for property: ' + propertyId);
    }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/brick-website/resources/views/propety/property-details.blade.php ENDPATH**/ ?>