<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PropertyController;
use App\Http\Middleware\RoleRedirect;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProjectController;

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Regular User Dashboard
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    // Builder Dashboard
    Route::get('/builder/dashboard', function () {
        // You would create a new view for this
        return view('builder.dashboard'); 
    })->name('builder.dashboard');

    // Admin Dashboard
    Route::get('/admin/dashboard', function () {
        // And another new view for this
        return view('admin.dashboard');
    })->name('admin.dashboard');
});

Route::middleware(['auth', 'is.builder'])->group(function () {
    Route::resource('properties', PropertyController::class);
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified', RoleRedirect::class])->name('dashboard');

Route::view('/packages', 'services.packages')->name('packages');
Route::view('/architech', 'services.architech')->name('architech');
Route::view('/home-loan', 'services.home-loan')->name('home-loan');
Route::view('/warehouse-construction', 'services.warehouse-construction')->name('warehouse-construction');
Route::view('/vastu-shastra', 'services.vastu-shastra')->name('vastu-shastra');
Route::view('/about', 'about')->name('about');
Route::view('/contact', 'contact')->name('contact');
Route::view('/property-details', 'propety.property-details')->name('propety.details');
Route::get('/property/{id}', [PropertyController::class, 'show'])->name('property.show');
Route::get('/search', [PropertyController::class, 'search'])->name('property.search');

Route::get('/new-projects', [PropertyController::class, 'projectsIndex'])->name('properties.projects');
Route::get('/properties-for-rent', [PropertyController::class, 'rentIndex'])->name('properties.rent');
Route::get('/properties-for-sale', [PropertyController::class, 'saleIndex'])->name('properties.sale');

Route::get('/projects/{project}', [ProjectController::class, 'show'])->name('project.show');


Route::post('/razorpay/create-order', [PaymentController::class, 'createOrder'])->name('razorpay.create')->middleware('auth');
Route::post('/payments/verify', [PaymentController::class, 'verify'])->name('payments.verify')->middleware('auth');

require __DIR__.'/auth.php';
