@extends('layouts.guest')

@section('title', 'Packages')

@section('content')
<div class="bg-gray-50 py-16 px-4">
    <div class="max-w-6xl mx-auto text-center">
        <h2 class="text-sm font-semibold text-gray-500 uppercase">Pricing Plan</h2>
        <h1 class="text-3xl md:text-4xl font-bold text-gray-800 mt-2">
            Simple prices, flexible options & nothing hidden
        </h1>
    </div>

    @php
        $gstPercent = 18;
        $packages = [
            ['id'=>'gold','name'=>'Gold','leads'=>200,'price'=>70000,'color'=>'border-yellow-400'],
            ['id'=>'platinum','name'=>'Platinum','leads'=>300,'price'=>105000,'color'=>'border-gray-300'],
            ['id'=>'diamond','name'=>'Diamond','leads'=>500,'price'=>175000,'color'=>'bg-green-500 text-white','highlight'=>true],
            ['id'=>'elite','name'=>'Elite','leads'=>1000,'price'=>350000,'color'=>'border-gray-300'],
        ];
    @endphp

    <div class="mt-12 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 max-w-6xl mx-auto">
        @foreach($packages as $pkg)
            @php
                $gstAmount = round($pkg['price'] * $gstPercent / 100);
                $total = $pkg['price'] + $gstAmount;
                $isHighlight = isset($pkg['highlight']) && $pkg['highlight'];
            @endphp

            <div class="flex flex-col justify-between border rounded-2xl p-8 text-center {{ $isHighlight ? 'bg-green-500 text-white shadow-xl scale-105' : 'bg-white hover:shadow-lg transition' }}">
                <div>
                    <h3 class="text-xl font-semibold mb-2">{{ $pkg['name'] }}</h3>
                    <p class="text-4xl font-bold mb-4">
                        ₹{{ number_format($pkg['price']) }}
                        <span class="text-base font-normal align-top">+GST</span>
                    </p>
                    <ul class="space-y-2 text-sm {{ $isHighlight ? 'text-green-50' : 'text-gray-600' }}">
                        <li>{{ $pkg['leads'] }} Leads</li>
                        <li>Verified Contacts</li>
                        <li>Dedicated Support</li>
                        <li>Instant Activation</li>
                    </ul>
                </div>

                <div class="mt-6">
                    @auth
                        <button
                            onclick="startCheckout('{{ $pkg['id'] }}', {{ $pkg['price'] }}, {{ $gstPercent }})"
                            class="w-full py-2 rounded-lg font-semibold {{ $isHighlight ? 'bg-white text-green-600 hover:bg-green-100' : 'bg-yellow-400 hover:bg-yellow-500 text-gray-900' }}"
                        >
                            Buy {{ $pkg['name'] }}
                        </button>
                    @else
                        <button
                            onclick="showLoginPrompt()"
                            class="w-full py-2 rounded-lg font-semibold {{ $isHighlight ? 'bg-white text-green-600 hover:bg-green-100' : 'bg-yellow-400 hover:bg-yellow-500 text-gray-900' }}"
                        >
                            Login to Buy
                        </button>
                    @endauth
                </div>
            </div>
        @endforeach
    </div>
</div>

<!-- Login modal -->
<div id="loginModal" class="fixed inset-0 bg-black/50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 w-full max-w-md">
        <h3 class="text-xl font-semibold mb-2">Login Required</h3>
        <p class="text-gray-600 mb-4">Please login or register to buy a package.</p>
        <div class="flex gap-3">
            <a href="{{ route('login') }}" class="flex-1 text-center bg-blue-600 text-white py-2 rounded-lg">Login</a>
            <a href="{{ route('register') }}" class="flex-1 text-center border py-2 rounded-lg">Register</a>
        </div>
        <button onclick="closeLoginPrompt()" class="mt-4 text-sm text-gray-500">Cancel</button>
    </div>
</div>

<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
const RAZORPAY_KEY = window.RAZORPAY_KEY || '{{ config('services.razorpay.key') ?? '' }}';

function showLoginPrompt() {
    document.getElementById('loginModal').classList.remove('hidden');
    document.getElementById('loginModal').classList.add('flex');
}
function closeLoginPrompt() {
    document.getElementById('loginModal').classList.add('hidden');
    document.getElementById('loginModal').classList.remove('flex');
}

async function startCheckout(packageId, basePrice, gstPercent) {
    const gst = Math.round(basePrice * gstPercent / 100);
    const total = basePrice + gst;
    const amountPaise = total * 100;

    try {
        const res = await fetch("{{ route('razorpay.create') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ package_id: packageId, amount: total })
        });
        const data = await res.json();
        const orderId = data.order_id;

        const options = {
            key: RAZORPAY_KEY,
            amount: amountPaise,
            currency: "INR",
            name: "Your Company Name",
            description: `${packageId} Package`,
            order_id: orderId,
            handler: function (response){
                verifyPayment(response, packageId);
            },
            prefill: {
                name: "{{ Auth::user()->name ?? '' }}",
                email: "{{ Auth::user()->email ?? '' }}"
            },
            theme: { color: "#22c55e" }
        };
        const rzp = new Razorpay(options);
        rzp.on('payment.failed', function (resp) {
            alert('Payment failed: ' + (resp.error?.description || ''));
        });
        rzp.open();
    } catch (err) {
        alert('Could not initiate payment');
    }
}

async function verifyPayment(response, packageId) {
    const res = await fetch("{{ route('payments.verify') }}", {
        method: 'POST',
        headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
        body: JSON.stringify(response)
    });
    const data = await res.json();
    if (data.success) window.location.reload();
    else alert('Payment verification failed.');
}
</script>
@endsection

