@extends('layouts.guest')

@section('title', 'About Us - Bricklet')

@section('content')
<div class="bg-blue-50 min-h-screen py-14 px-4">
    <div class="max-w-3xl mx-auto">
        <!-- Hero/Intro Section -->
        <section class="mb-10 text-center">
            <h1 class="text-3xl font-extrabold text-blue-900 mb-2">Home Loan</h1>
            <p class="text-lg text-gray-700 max-w-xl mx-auto">
                Secure your dream home with competitive home loan offers from leading banks and lenders. Fast approvals, flexible payments, and personalized guidance—whether you have high or low CIBIL!
            </p>
        </section>

        <!-- Loan Providers Table -->
        <section class="mb-8">
            <h2 class="text-xl font-bold text-blue-800 mb-3">Featured Banks & Offers</h2>
            <table class="w-full text-left bg-white rounded-lg shadow overflow-hidden mb-4">
                <thead class="bg-blue-100 text-blue-900">
                    <tr>
                        <th class="px-4 py-2">Bank/Lender</th>
                        <th class="px-4 py-2">Interest Rate</th>
                        <th class="px-4 py-2">Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="px-4 py-2 font-semibold">State Bank Of India</td>
                        <td class="px-4 py-2">8.25% – 8.55%</td>
                        <td class="px-4 py-2">Depending on CIBIL</td>
                    </tr>
                    <tr>
                        <td class="px-4 py-2 font-semibold">UCO Bank</td>
                        <td class="px-4 py-2">8.15% – 8.60%</td>
                        <td class="px-4 py-2">Depending on CIBIL</td>
                    </tr>
                    <tr>
                        <td class="px-4 py-2 font-semibold">LIC HFL</td>
                        <td class="px-4 py-2">8.25% – 8.50%</td>
                        <td class="px-4 py-2">Depending on CIBIL</td>
                    </tr>
                    <tr>
                        <td class="px-4 py-2 font-semibold">IIFL Finance</td>
                        <td class="px-4 py-2 text-blue-700 font-medium">Easy Home Loan</td>
                        <td class="px-4 py-2">Even with low CIBIL</td>
                    </tr>
                </tbody>
            </table>
        </section>
        
        <!-- Lead Capture Form -->
        <section class="bg-white p-8 rounded-lg shadow">
            <h2 class="text-lg font-bold text-blue-900 mb-4">Get a Personalized Offer</h2>
            <form class="space-y-4">
                <input type="text" name="name" placeholder="Name" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                <input type="text" name="phone" placeholder="Phone Number" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                <input type="email" name="email" placeholder="Email" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                <select name="bank" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200">
                    <option value="">Preferred Bank Name</option>
                    <option value="SBI">State Bank Of India</option>
                    <option value="UCO">UCO Bank</option>
                    <option value="LIC HFL">LIC HFL</option>
                    <option value="IIFL Finance">IIFL Finance</option>
                </select>
                <button type="submit" class="w-full bg-blue-700 text-white py-2 rounded font-semibold hover:bg-blue-900 transition">Submit</button>
            </form>
        </section>
    </div>
</div>

@endsection
