@extends('layouts.guest')


@section('content')
<div class="container mx-auto px-4 py-10">
    <h2 class="text-2xl font-bold mb-6">Search Results ({{ $properties->total() }})</h2>

    <form method="GET" action="{{ route('property.search') }}" class="mb-8 flex flex-wrap gap-4">
        <select name="property_type" class="border rounded px-3 py-2" value="{{ $filters['property_type'] ?? '' }}">
            <option value="">All Types</option>
            <option value="buy" {{ (isset($filters['property_type']) && $filters['property_type'] == 'buy') ? 'selected' : '' }}>Buy</option>
            <option value="rent" {{ (isset($filters['property_type']) && $filters['property_type'] == 'rent') ? 'selected' : '' }}>Rent</option>
            <option value="commercial" {{ (isset($filters['property_type']) && $filters['property_type'] == 'commercial') ? 'selected' : '' }}>Commercial</option>
        </select>

        <select name="city" class="border rounded px-3 py-2" value="{{ $filters['city'] ?? '' }}">
            <option value="">All Cities</option>
            <option value="Guwahati" {{ (isset($filters['city']) && $filters['city'] == 'Guwahati') ? 'selected' : '' }}>Guwahati</option>
            <option value="Mumbai" {{ (isset($filters['city']) && $filters['city'] == 'Mumbai') ? 'selected' : '' }}>Mumbai</option>
            <option value="Delhi" {{ (isset($filters['city']) && $filters['city'] == 'Delhi') ? 'selected' : '' }}>Delhi</option>
            <!-- Add your other cities here -->
        </select>

        <input type="text" name="q" class="border rounded px-3 py-2 flex-1" placeholder="Search..." value="{{ $filters['q'] ?? '' }}" />

        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">Search</button>
    </form>

    @if($properties->count())
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            @foreach($properties as $property)
                <a href="{{ route('property.show', $property->id) }}" class="bg-white rounded shadow hover:shadow-lg border overflow-hidden block no-underline text-inherit">
                    <img src="{{ $property->main_image_url }}" class="h-40 w-full object-cover" />
                    <div class="p-4">
                        <div class="font-semibold text-lg truncate">{{ $property->title }}</div>
                        <div class="text-xs text-gray-500">{{ $property->city }}, {{ $property->state }}</div>
                        <div class="text-xs text-gray-500">{{ $property->bedrooms }} BHK · {{ ucfirst($property->type) }}</div>
                        <div class="text-lg font-bold mt-1">₹{{ number_format($property->price) }}</div>
                    </div>
                </a>
            @endforeach
        </div>

        <div class="mt-8">
            {{ $properties->appends(request()->query())->links() }}
        </div>
    @else
        <p class="text-center text-gray-600 text-lg">No properties found matching your search criteria.</p>
    @endif
</div>
@endsection

