@extends('layouts.guest')

@section('title', 'Rent - Bricklet')

@section('content')
<div class="bg-gray-100 py-6 min-h-screen">
    <div class="max-w-7xl mx-auto px-4">
        <!-- Filters -->
        <form id="filterForm" class="flex flex-wrap gap-4 bg-white p-4 rounded-lg shadow mb-6">
            <select name="bhk_type" class="border rounded px-3 py-2">
                <option value="">BHK Type</option>
                <option value="1">1 BHK</option>
                <option value="2">2 BHK</option>
                <option value="3">3 BHK</option>
            </select>
            <select name="price_range" class="border rounded px-3 py-2">
                <option value="">Price Range</option>
                <option value="0-30000">₹0 - ₹30K</option>
                <option value="30001-50000">₹30K - ₹50K</option>
                <option value="50001-100000">₹50K+</option>
            </select>
            <select name="furnishing" class="border rounded px-3 py-2">
                <option value="">Furnishing</option>
                <option value="Fully">Fully Furnished</option>
                <option value="Semi">Semi Furnished</option>
                <option value="Unfurnished">Unfurnished</option>
            </select>
            <select name="property_type" class="border rounded px-3 py-2">
                <option value="">Property Type</option>
                <option value="Apartment">Apartment</option>
                <option value="House">House</option>
            </select>
            <button type="submit" class="ml-auto bg-blue-600 text-white px-4 py-2 rounded">Apply Filters</button>
        </form>

        <!-- Listings & Sidebar -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Listings Left -->
            <div class="md:col-span-2" id="listingArea">
                @include('property.partials.rent_list', ['properties' => $properties, 'total_properties' => $total_properties])
            </div>
            <!-- Sidebar/ad (same as before) -->
            <aside class="md:col-span-1 flex flex-col gap-5">
                <!-- Ad blocks here -->
                <div class="bg-white p-5 rounded-lg shadow text-center"> ... </div>
                <div class="bg-white p-5 rounded-lg shadow text-center"> ... </div>
            </aside>
        </div>
    </div>
</div>
<!-- Login Popup Modal -->
<div id="loginModal" class="fixed inset-0 bg-black bg-opacity-40 z-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg p-8 shadow-lg w-full max-w-md text-center">
        <h3 class="text-xl font-bold mb-4 text-gray-900">Sign in to continue</h3>
        <p class="text-gray-700 mb-6">To like or save a property, please login or register for free.</p>
        <a href="{{ route('login') }}" class="bg-blue-600 text-white font-semibold px-6 py-2 rounded mr-2 hover:bg-blue-700 transition">Login</a>
        <a href="{{ route('register') }}" class="bg-gray-100 text-blue-600 font-semibold px-6 py-2 rounded hover:bg-gray-200 transition">Register</a>
        <button onclick="closeLoginPopup()" class="block mt-8 text-gray-500 hover:text-gray-800 mx-auto">Close</button>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
function closeLoginPopup() {
        document.getElementById('loginModal').classList.add('hidden');
    }
$('#filterForm').on('submit', function(e){
    e.preventDefault();
    var $form = $(this);
    $.get("{{ route('properties.rent') }}", $form.serialize(), function(data){
        $('#listingArea').html(data);
    });
});
// For pagination links via AJAX
$(document).on('click', '#listingArea .pagination a', function(e){
    e.preventDefault();
    var url = $(this).attr('href');
    $.get(url, $('#filterForm').serialize(), function(data){
        $('#listingArea').html(data);
    });
});
// Guest "Contact" button
window.showLoginPopup = function() {
    $('#loginModal').removeClass('hidden');
}
</script>
@endpush
