@extends('layouts.guest')

@section('title', $property->title . ' - RealtyCo')

@section('content')
<div class="container mx-auto px-6 py-12">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">

        <!-- Image Gallery -->
        <div class="lg:col-span-2">
            <div class="relative w-full h-96 rounded-lg overflow-hidden shadow-lg">
                <img src="{{ $property->main_image_url }}" alt="{{ $property->title }}" class="w-full h-full object-cover">
                <!-- TODO: Add slider arrows / thumbnails -->
            </div>
            <div class="mt-4 grid grid-cols-4 gap-4">
                @foreach($property->images as $image)
                    <img src="{{ $image->url }}" alt="{{ $property->title }}" class="w-full h-24 object-cover rounded cursor-pointer hover:ring-2 hover:ring-blue-600" onclick="document.querySelector('.relative.w-full').firstElementChild.src='{{ $image->url }}'">
                @endforeach
            </div>
        </div>

        <!-- Property Summary and Actions -->
        <div class="space-y-6">
            <h1 class="text-3xl font-bold text-gray-900">{{ $property->title }}</h1>
            <p class="text-gray-600">{{ $property->location }}</p>
            <p class="text-blue-600 text-3xl font-extrabold">{{ $property->price_display }}</p>

            <div class="flex flex-wrap gap-4 text-gray-700">
                <div class="flex items-center gap-2">
                    <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M8 7v10l5-5-5-5z"/></svg>
                    <span>{{ $property->bedrooms }} Beds</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M12 7v10"/></svg>
                    <span>{{ $property->bathrooms }} Baths</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M3 7h18"/></svg>
                    <span>{{ $property->area }} sqft</span>
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex flex-col space-y-4 sm:flex-row sm:space-y-0 sm:space-x-4">
                @auth
                    <button class="flex-1 bg-blue-600 text-white font-bold py-3 rounded hover:bg-blue-700 transition" onclick="contactAgent({{ $property->agent_id }})">Contact Agent</button>
                    <button class="flex-1 border border-blue-600 text-blue-600 font-semibold py-3 rounded hover:bg-blue-50 transition" onclick="scheduleVisit({{ $property->id }})">Schedule Visit</button>
                @else
                    <button class="flex-1 bg-blue-600 text-white font-bold py-3 rounded hover:bg-blue-700 transition" onclick="showLoginPrompt()">Contact Agent</button>
                    <button class="flex-1 border border-blue-600 text-blue-600 font-semibold py-3 rounded hover:bg-blue-50 transition" onclick="showLoginPrompt()">Schedule Visit</button>
                @endauth
            </div>

            <!-- Description -->
            <section>
                <h2 class="text-xl font-semibold text-gray-900 mb-2">About this Property</h2>
                <p class="text-gray-700 whitespace-pre-line">{{ $property->description }}</p>
            </section>

            <!-- Amenities -->
            @if($property->amenities->count())
            <section class="mt-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Amenities</h2>
                <ul class="grid grid-cols-2 sm:grid-cols-3 gap-4 text-gray-700">
                    @foreach($property->amenities as $amenity)
                        <li class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                            <span>{{ $amenity->name }}</span>
                        </li>
                    @endforeach
                </ul>
            </section>
            @endif

        </div>
    </div>
</div>

<script>
    function showLoginPrompt() {
        // Show login popup modal similar to previous code
        // For example:
        document.getElementById('login-popup').classList.remove('hidden');
    }
    function contactAgent(agentId) {
        // Implement contact agent logic here or redirect to contact form
        alert('Contact agent: ' + agentId);
    }
    function scheduleVisit(propertyId) {
        // Redirect or show a form to schedule a visit
        alert('Schedule visit for property: ' + propertyId);
    }
</script>
@endsection

