@extends('layouts.guest')

@section('title', 'Projects - Bricklet')

@section('content')

<div class="bg-gray-100 py-6 min-h-screen">
    <div class="max-w-7xl mx-auto px-4">
        <!-- Filters -->
        <form id="filterProjectForm" class="flex flex-wrap gap-4 bg-white p-4 rounded-lg shadow mb-6">
            <select name="city" class="border rounded px-3 py-2">
                <option value="">City</option>
                <option value="Guwahati">Guwahati</option>
                <option value="Jaipur">Jaipur</option>
                <!-- Fill more cities -->
            </select>
            <select name="status" class="border rounded px-3 py-2">
                <option value="">Status</option>
                <option value="Ready To Move">Ready To Move</option>
                <option value="Under Construction">Under Construction</option>
            </select>
            <input name="builder" class="border rounded px-3 py-2" placeholder="Builder Name" value="{{ request('builder') }}" />
            <input name="config" class="border rounded px-3 py-2" placeholder="Configuration (2/3/4 BHK)" value="{{ request('config') }}" />
            <input name="possession_year" type="number" class="border rounded px-3 py-2" placeholder="Possession Year" value="{{ request('possession_year') }}" />
            <button type="submit" class="ml-auto bg-blue-600 text-white px-4 py-2 rounded">Apply Filters</button>
        </form>

        <!-- Listings & Sidebar -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Listings Left -->
            <div class="md:col-span-2" id="projectsListingArea">
                @include('property.partials.project_list', ['projects' => $projects, 'total_projects' => $total_projects])
            </div>
            <!-- Sidebar/ad -->
            <aside class="md:col-span-1 flex flex-col gap-5">
                <div class="bg-white p-5 rounded-lg shadow text-center"> ... </div>
                <div class="bg-white p-5 rounded-lg shadow text-center"> ... </div>
            </aside>
        </div>
    </div>
</div>
<div id="loginModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg p-8 relative">
        <span class="absolute top-2 right-2 cursor-pointer font-bold text-xl" onclick="$('#loginModal').addClass('hidden');">&times;</span>
        <h2 class="text-xl mb-2">Please log in to continue</h2>
        <a href="{{ route('login') }}" class="bg-blue-600 text-white px-4 py-2 rounded">Go to Login</a>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
$('#filterProjectForm').on('submit', function(e){
    e.preventDefault();
    var $form = $(this);
    $.get("{{ route('properties.projects') }}", $form.serialize(), function(data){
        $('#projectsListingArea').html(data);
    });
});
$(document).on('click', '#projectsListingArea .pagination a', function(e){
    e.preventDefault();
    var url = $(this).attr('href');
    $.get(url, $('#filterProjectForm').serialize(), function(data){
        $('#projectsListingArea').html(data);
    });
});
window.showLoginPopup = function() {
    $('#loginModal').removeClass('hidden');
}
</script>
@endpush

