<div class="text-sm mb-3">
    Showing {{ $properties->firstItem() }} - {{ $properties->lastItem() }} of {{ $total_properties }} properties
</div>
@forelse($properties as $property)
    <div class="flex bg-white rounded-lg shadow p-4 mb-5">
        <img src="{{ $property->main_image_url }}" alt="{{ $property->title }}" class="w-36 h-28 object-cover rounded mr-4" />
        <div class="flex-1">
            <div class="font-medium text-lg">{{ $property->title }}</div>
            <div class="text-gray-700 mb-1">₹{{ number_format($property->price) }} | {{ $property->area }} sq.ft | {{ ucfirst($property->furnishing) }}</div>
            <div class="text-gray-500 text-sm mb-1">Amenities: {{ $property->amenities }}</div>
            <div class="text-gray-400 text-xs">Listed by {{ $property->listed_by }}</div>
        </div>
        <div>
            @auth
                <a href="{{ route('properties.show', $property->id) }}" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Contact</a>
            @else
                <button type="button" onclick="showLoginPopup()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Contact</button>
            @endauth
        </div>
    </div>
@empty
    <div class="mt-6 bg-white p-8 rounded shadow text-center text-gray-600">
        No properties found for the selected filters.
    </div>
@endforelse

<div class="mt-6">
    {!! $properties->links() !!}
</div>

