<div class="text-sm mb-3">
    Showing {{ $projects->firstItem() }} - {{ $projects->lastItem() }} of {{ $total_projects }} projects
</div>
@forelse($projects as $project)
    <div class="flex bg-white rounded-lg shadow p-4 mb-5">
        <img src="{{ $project->main_image_url }}" alt="{{ $project->name }}" class="w-36 h-28 object-cover rounded mr-4" />
        <div class="flex-1">
            <div class="font-medium text-lg">{{ $project->name }}</div>
            <div class="text-gray-700 mb-1">{{ $project->builder }} &middot; {{ $project->city }}</div>
            <div class="text-gray-500 text-sm mb-1">
                Configurations: {{ $project->configurations }} |
                Status: {{ $project->status }} |
                Possession: {{ \Carbon\Carbon::parse($project->possession_date)->format('Y') }}
            </div>
            <div class="text-gray-400 text-xs">Contact: {{ $project->contact_phone }}</div>
        </div>
        <div>
            @auth
                <a href="{{ route('projects.show', $project->id) }}" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Enquire</a>
            @else
                <button type="button" onclick="showLoginPopup()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md">Enquire</button>
            @endauth
        </div>
    </div>
@empty
    <div class="mt-6 bg-white p-8 rounded shadow text-center text-gray-600">
        No projects found for the selected filters.
    </div>
@endforelse

<div class="mt-6">
    {!! $projects->links() !!}
</div>

