<nav class="bg-white shadow-lg">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex space-x-8">
                <!-- Logo/Brand -->
                <div class="flex-shrink-0 flex items-center">
                    <a href="/" class="text-xl font-bold text-gray-800">
                        Bricklet
                    </a>
                </div>
                
                <!-- Navigation Links -->
                <div class="hidden md:flex md:space-x-8 md:items-center">
                    <a href="/" class="text-gray-700 hover:text-gray-900 px-3 py-2 text-sm font-medium">
                        Home
                    </a>
                    
                    <!-- Services Dropdown -->
                    <div class="relative group">
                        <button class="text-gray-700 hover:text-gray-900 px-3 py-2 text-sm font-medium inline-flex items-center">
                            Services
                            <svg class="ml-1 h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                            </svg>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div class="absolute left-0 mt-2 w-64 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                            <div class="py-1">
                                <a href="{{ route('packages') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Packages
                                </a>
                                <a href="{{ route('architech') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Architect & Interior Design
                                </a>
                                <a href="{{ route('home-loan') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Home Loan
                                </a>
                                <a href="{{ route('warehouse-construction') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Warehouse Construction
                                </a>
                                <a href="{{ route('vastu-shastra') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Vastu Shastra
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <a href="{{ route('about') }}" class="text-gray-700 hover:text-gray-900 px-3 py-2 text-sm font-medium">
                        About
                    </a>
                    <a href="{{ route('contact') }}" class="text-gray-700 hover:text-gray-900 px-3 py-2 text-sm font-medium">
                        Contact
                    </a>
                </div>
            </div>
            
            <!-- Right side - Login/Register -->
            <div class="hidden md:flex md:items-center md:space-x-4">
                @auth
                    <a href="{{ route('dashboard') }}" class="text-gray-700 hover:text-gray-900 px-3 py-2 text-sm font-medium">
                        Dashboard
                    </a>
                @else
                    <a href="{{ route('login') }}" class="text-gray-700 hover:text-gray-900 px-3 py-2 text-sm font-medium">
                        Login
                    </a>
                    <a href="{{ route('register') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-medium hover:bg-blue-700">
                        Register
                    </a>
                @endauth
            </div>
            
            <!-- Mobile menu button -->
            <div class="flex items-center md:hidden">
                <button id="mobile-menu-button" class="text-gray-700 hover:text-gray-900 focus:outline-none">
                    <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </button>
            </div>
        </div>
    </div>
    
    <!-- Mobile menu -->
    <div id="mobile-menu" class="hidden md:hidden">
        <div class="px-2 pt-2 pb-3 space-y-1">
            <a href="/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md">
                Home
            </a>
            
            <!-- Mobile Services Submenu -->
            <div>
                <button id="mobile-services-button" class="w-full text-left px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md flex justify-between items-center">
                    Services
                    <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                    </svg>
                </button>
                <div id="mobile-services-menu" class="hidden pl-4 space-y-1">
                    <a href="{{ route('packages') }}" class="block px-3 py-2 text-sm text-gray-600 hover:bg-gray-100 rounded-md">
                        Packages
                    </a>
                    <a href="{{ route('architech') }}" class="block px-3 py-2 text-sm text-gray-600 hover:bg-gray-100 rounded-md">
                        Architect & Interior Design
                    </a>
                    <a href="{{ route('home-loan') }}" class="block px-3 py-2 text-sm text-gray-600 hover:bg-gray-100 rounded-md">
                        Home Loan
                    </a>
                    <a href="{{ route('warehouse-construction') }}" class="block px-3 py-2 text-sm text-gray-600 hover:bg-gray-100 rounded-md">
                        Warehouse Construction
                    </a>
                    <a href="{{ route('vastu-shastra') }}" class="block px-3 py-2 text-sm text-gray-600 hover:bg-gray-100 rounded-md">
                        Vastu Shastra
                    </a>
                </div>
            </div>
            
            <a href="{{ route('about') }}" class="block px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md">
                About
            </a>
            <a href="{{ route('contact') }}" class="block px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md">
                Contact
            </a>
            
            @auth
                <a href="{{ route('dashboard') }}" class="block px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md">
                    Dashboard
                </a>
            @else
                <a href="{{ route('login') }}" class="block px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md">
                    Login
                </a>
                <a href="{{ route('register') }}" class="block px-3 py-2 text-base font-medium text-gray-700 hover:bg-gray-100 rounded-md">
                    Register
                </a>
            @endauth
        </div>
    </div>
</nav>

<script>
    // Mobile menu toggle
    document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
        document.getElementById('mobile-menu').classList.toggle('hidden');
    });
    
    // Mobile services submenu toggle
    document.getElementById('mobile-services-button')?.addEventListener('click', function() {
        document.getElementById('mobile-services-menu').classList.toggle('hidden');
    });
</script>

