@extends('layouts.guest')

@section('title', 'About Us - Bricklet')

@section('content')
<div class="bg-blue-50 min-h-screen py-16">
    <div class="max-w-6xl mx-auto grid grid-cols-1 md:grid-cols-3 gap-12 px-4">

        <!-- Left/Main Form Area -->
        <div class="md:col-span-2">
            <h1 class="text-3xl font-extrabold text-gray-900 mb-2">Get in touch with us</h1>
            <p class="text-lg text-gray-700 mb-6">Find the best deal on homes in your area. Let us help you.</p>

            <form class="space-y-4">
                <select name="user_type" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200">
                    <option value="">Select</option>
                    <option value="I want to buy">I want to buy</option>
                    <option value="I want to sell">I want to sell</option>
                </select>
                <input type="text" name="name" placeholder="Name" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                <div class="grid grid-cols-2 gap-4">
                    <input type="email" name="email" placeholder="Email" required class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                    <input type="text" name="phone" placeholder="Phone" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <input type="text" name="city" placeholder="City" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                <input type="text" name="zip" placeholder="Zip Code" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />

                <textarea name="message" rows="4" placeholder="Message" class="w-full px-3 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200"></textarea>
                <div class="flex items-center mb-3">
                    <input type="checkbox" id="gdpr_agreement" required class="mr-2" />
                    <label for="gdpr_agreement" class="text-xs text-gray-700">I consent to having this website store my submitted information</label>
                </div>
                <button type="submit" class="w-full bg-blue-900 text-white py-2 rounded font-semibold hover:bg-blue-800 transition">SUBMIT</button>
            </form>
        </div>

        <!-- Right Column: Address, Map, Social -->
        <div class="md:col-span-1 flex flex-col space-y-6">
            <!-- Map HTML -->
            <div class="w-full h-52 rounded-lg shadow overflow-hidden mb-3">
                <iframe
                    class="w-full h-full border-0"
                    loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"
                    src="https://maps.google.com/maps?q=Bricklet%20%2C%20Lachit%20Nagar%20Main%20Road%2C%20Guwahati%2C%20Assam%2C%20India&t=m&z=15&output=embed&iwloc=near"
                    allowfullscreen
                    title="Bricklet Location"></iframe>
            </div>
            <!-- Address & Phone -->
            <div class="mb-1">
                <div class="flex items-center text-blue-900 mb-2">
                    <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle cx="12" cy="9.5" r="2.5"/><path stroke-width="2" d="M12 2C8.134 2 5 5.267 5 9.5c0 4.856 6.07 11.59 6.323 11.86a1 1 0 0 0 1.354 0C12.93 21.09 19 14.356 19 9.5 19 5.267 15.866 2 12 2z"></path></svg>
                    House NO.29, Lachit Nagar Main Road,<br>Guwahati, Assam, India
                </div>
                <div class="flex items-center text-blue-900">
                    <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M17 10.5V6a5 5 0 0 0-10 0v4.5"></path><rect width="20" height="12" x="2" y="10.5" rx="2"></rect></svg>
                    <a href="tel:+919395575146" class="underline ml-1">+91 93955 75146</a>
                </div>
            </div>
            <!-- Social HTML code -->
            <div>
                <span class="font-semibold text-gray-700 block mb-2">FIND US ON</span>
                <div class="flex space-x-4 text-2xl">
                    <a href="https://www.instagram.com/bricklet.in/?hl=en" class="text-pink-600 hover:text-pink-800" target="_blank"><i class="fab fa-instagram"></i></a>
                    <a href="https://www.facebook.com/www.bricklet.in" class="text-blue-600 hover:text-blue-900" target="_blank"><i class="fab fa-facebook-f"></i></a>
                    <a href="https://www.youtube.com/@BrickletRealEstate" class="text-red-600 hover:text-red-900" target="_blank"><i class="fab fa-youtube"></i></a>
                    <a href="#" class="text-blue-500 hover:text-blue-700" target="_blank"><i class="fab fa-linkedin"></i></a>
                    <a href="https://wa.me/9395575146" class="text-green-600 hover:text-green-800" target="_blank"><i class="fab fa-whatsapp"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Font Awesome for social icons (only add if not already included globally) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />


@endsection
