@extends('layouts.guest')

@section('title', 'About Us - Bricklet')

@section('content')
<div class="bg-white pb-24">

    <!-- NEWSLETTER PROMO -->
    <section class="w-full py-8 bg-blue-50 text-center">
        <h2 class="text-xl font-semibold mb-2">Sign up to our newsletter</h2>
        <p class="text-gray-600">Keep in touch with the latest updates</p>
        <form class="mt-4 flex max-w-md mx-auto gap-2">
            <input type="email" class="flex-1 px-4 py-2 border border-gray-300 rounded-md focus:ring focus:ring-blue-200" placeholder="Email address">
            <button type="submit" class="px-6 py-2 bg-blue-900 text-white rounded-md font-semibold">SUBMIT</button>
        </form>
    </section>

    <!-- ABOUT AND SERVICES -->
    <section class="max-w-6xl mx-auto py-12 px-4">
        <!-- Services for Promoters -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center mb-16">
            <div class="flex justify-center">
                <img src="/images/Screenshot-2025-05-22-123923.png.webp" alt="Property Listing" class="rounded-xl shadow-xl object-cover w-full max-w-md bg-white" />
            </div>
            <div>
                <h2 class="text-2xl font-bold mb-4">Engaging Property Listing</h2>
                <p class="text-gray-700 mb-4">
                    At Bricklet, our property listings are designed to captivate and inspire. Each listing features high-quality images, detailed descriptions, and interactive virtual tours that bring every space to life. Whether you’re browsing for your dream home or scouting commercial opportunities, our engaging listings provide an immersive experience, making it easier than ever to envision your next move.
                </p>
                <ul class="space-y-2 text-gray-800 mb-4">
                    <li><span class="text-blue-600 mr-2">•</span> CRM by Bricklet – Seamless lead management</li>
                    <li><span class="text-blue-600 mr-2">•</span> Lead Generation Package – Verified leads for faster sales</li>
                </ul>
            </div>
        </div>

        <!-- Services for Buyers and Sellers 1 -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center mb-16">
            <div class="flex gap-6">
                <img src="/images/freepik__upload__7633.jpeg.webp" alt="Buy & Sell Properties" class="rounded-xl shadow-md w-40 object-cover bg-white" />
                <img src="/images/Vaani-profile-Picture.png.webp" alt="Vaani AI" class="rounded-xl shadow-md w-36 object-cover bg-white" />
            </div>
            <div>
                <h2 class="text-2xl font-bold mb-4">Services for Buyers and Sellers</h2>
                <ul class="space-y-2 text-gray-800">
                    <li><span class="text-blue-600 mr-2">•</span> Buy & Sell Properties – Zero hidden costs</li>
                    <li><span class="text-blue-600 mr-2">•</span> Vaani – AI Chat bot for harmonious spaces</li>
                    <li><span class="text-blue-600 mr-2">•</span> Home loan assistance</li>
                    <li><span class="text-blue-600 mr-2">•</span> Construction & interior consultation</li>
                </ul>
            </div>
        </div>

        <!-- Services for Buyers and Sellers 2 (Grid Layout) -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mb-16">
            <div class="bg-blue-50 p-4 rounded-xl flex flex-col items-center shadow">
                <img src="/images/freepik__upload__7633.jpeg.webp" alt="Buy & Sell Properties" class="w-28 h-28 mb-2 object-cover rounded-xl" />
                <div class="font-semibold text-center">Buy & Sell Properties</div>
            </div>
            <div class="bg-blue-50 p-4 rounded-xl flex flex-col items-center shadow">
                <img src="/images/Vaani-profile-Picture.png.webp" alt="Vaani- AI Chatbot" class="w-24 h-24 mb-2 object-cover rounded-xl" />
                <div class="font-semibold text-center">Vaani- AI Chat bot</div>
            </div>
            <div class="bg-blue-50 p-4 rounded-xl flex flex-col items-center shadow">
                <img src="/images/Untitled-design-1.jpg.webp" alt="Home Loan Assistance" class="w-28 h-28 mb-2 object-cover rounded-xl" />
                <div class="font-semibold text-center">Home loan assistance</div>
            </div>
            <div class="bg-blue-50 p-4 rounded-xl flex flex-col items-center shadow">
                <img src="/images/Untitled-design-2.jpg.webp" alt="Construction & Interior" class="w-28 h-28 mb-2 object-cover rounded-xl" />
                <div class="font-semibold text-center">Construction and interior</div>
            </div>
        </div>

        <!-- Why Choose Bricklet -->
        <div class="text-center mb-16">
            <h2 class="text-2xl font-bold mb-8">Why Choose Bricklet?</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-10">
                <div>
                    <img src="/images/freepik__upload__93122-150x150.jpeg" alt="No Commission" class="mx-auto h-16 mb-3" />
                    <div class="font-bold mb-1">No Commission</div>
                    <p class="text-sm text-gray-600">Direct deals, no brokerage fees.</p>
                </div>
                <div>
                    <img src="/images/freepik__upload__70357-150x150.jpeg.webp" alt="Easy Transparent" class="mx-auto h-16 mb-3" />
                    <div class="font-bold mb-1">Easy & Transparent</div>
                    <p class="text-sm text-gray-600">Find your property without complications.</p>
                </div>
                <div>
                    <img src="/images/freepik__upload__16299-150x150.jpeg.webp" alt="Verified" class="mx-auto h-16 mb-3" />
                    <div class="font-bold mb-1">Trusted & Verified</div>
                    <p class="text-sm text-gray-600">Only genuine listings and high-quality leads.</p>
                </div>
                <div>
                    <img src="/images/freepik__upload__88574-150x150.jpeg.webp" alt="Presence in 9 states" class="mx-auto h-16 mb-3" />
                    <div class="font-bold mb-1">Presence in 9 states</div>
                    <p class="text-sm text-gray-600">Focused on modern real estate solutions.</p>
                </div>
            </div>
        </div>
            
        <!-- Our Vision -->
        <div class="bg-blue-50 rounded-xl p-8 shadow text-center mb-16">
            <h2 class="text-2xl font-bold mb-3">Our Vision</h2>
            <p class="text-gray-800 mb-2">To <span class="font-bold text-blue-700">revolutionize</span> the real estate industry by making property transactions <span class="font-semibold text-blue-700">seamless, transparent, and commission-free</span>.</p>
            <p class="text-gray-700">Join us in reshaping the future of real estate! Whether you are looking to <span class="font-bold">buy, sell, or rent</span>, Bricklet is here to simplify your journey.</p>
            <div class="mt-4">
                <a href="https://bricklet.in/" class="text-blue-700 underline font-semibold" target="_blank">Visit us at www.bricklet.in and start your real estate journey today!</a>
            </div>
        </div>

        <!-- Request a Free Valuation -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 bg-blue-100 p-8 rounded-xl shadow mb-16">
            <div>
                <h3 class="text-xl font-semibold mb-2">Request a free valuation of your property</h3>
                <p class="text-gray-700 mb-4">Our real estate company has a number of luxury and exclusive listings perfect for clients.</p>
                <div>
                    <p class="text-gray-600">Contact us<br>
                    <span class="italic text-blue-800 font-semibold">+919395657146</span></p>
                </div>
            </div>
            <form class="grid grid-cols-1 md:grid-cols-2 gap-4 items-end">
                <div>
                    <label class="block font-medium mb-1 text-gray-700">Type</label>
                    <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <div>
                    <label class="block font-medium mb-1 text-gray-700">Zip code</label>
                    <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <div>
                    <label class="block font-medium mb-1 text-gray-700">City</label>
                    <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <div>
                    <label class="block font-medium mb-1 text-gray-700">No. of bedrooms</label>
                    <input type="number" min="1" class="w-full px-4 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <div>
                    <label class="block font-medium mb-1 text-gray-700">No. of bathrooms</label>
                    <input type="number" min="1" class="w-full px-4 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <div>
                    <label class="block font-medium mb-1 text-gray-700">Your budget</label>
                    <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded focus:ring focus:ring-blue-200" />
                </div>
                <div class="col-span-1 md:col-span-2">
                    <button type="submit" class="w-full px-6 py-2 bg-blue-900 text-white rounded-md font-semibold">SUBMIT</button>
                </div>
            </form>
        </div>
    </section>
</div>

@endsection

