<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Project;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        Project::factory(10)
            ->create()
            ->each(function ($project) {
                $project->images()->createMany(
                    \App\Models\ProjectImage::factory(3)->make()->toArray()
                );

                $project->floorPlans()->createMany(
                    \App\Models\ProjectFloorPlan::factory(2)->make()->toArray()
                );

                $project->amenities()->createMany(
                    \App\Models\ProjectAmenity::factory(5)->make()->toArray()
                );

                $project->reviews()->createMany(
                    \App\Models\ProjectReview::factory(3)->make()->toArray()
                );

                $project->trends()->createMany(
                    \App\Models\ProjectTrend::factory(6)->make()->toArray()
                );
            });
    }
}

