<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_floor_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
		$table->string('config'); // 2 BHK, 3 BHK, etc.
		$table->integer('area')->nullable(); // sqft
		$table->bigInteger('price')->nullable();
		$table->integer('beds')->nullable();
		$table->integer('baths')->nullable();
		$table->string('image_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_floor_plans');
    }
};
