<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
		$table->string('name');
		$table->string('builder');
		$table->string('city')->nullable();
		$table->string('location')->nullable();
		$table->bigInteger('min_price')->nullable();
		$table->bigInteger('max_price')->nullable();
		$table->string('approval_code')->nullable();
		$table->string('configurations')->nullable();
		$table->date('possession_date')->nullable();
		$table->string('status')->nullable();
		$table->text('overview')->nullable();
		$table->text('specifications')->nullable();
		$table->string('brochure_url')->nullable();
		$table->decimal('latitude', 10, 6)->nullable();
		$table->decimal('longitude', 10, 6)->nullable();
		$table->string('contact_phone')->nullable();
		$table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
