<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comments', function (Blueprint $table) {
		$table->bigIncrements('id');
		$table->unsignedBigInteger('property_id');
		$table->unsignedBigInteger('user_id')->nullable(); // nullable for guest comments, if allowed
		$table->text('content');
		$table->integer('likes_count')->default(0);
		$table->timestamps();

		$table->foreign('property_id')->references('id')->on('properties')->onDelete('cascade');
		$table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
	    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comments');
    }
};
