<?php

namespace Database\Factories;

use App\Models\ProjectFloorPlan;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectFloorPlanFactory extends Factory
{
    protected $model = ProjectFloorPlan::class;

    public function definition()
    {
        return [
            'config'    => $this->faker->randomElement(['2 BHK', '3 BHK']),
            'area'      => $this->faker->numberBetween(1000, 1600),
            'price'     => $this->faker->numberBetween(4000000, 8000000),
            'beds'      => $this->faker->numberBetween(2, 4),
            'baths'     => $this->faker->numberBetween(1, 3),
            'image_url' => $this->faker->imageUrl(200, 150, 'architecture', true),
        ];
    }
}

