<?php

namespace Database\Factories;

use App\Models\Project;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectFactory extends Factory
{
    protected $model = Project::class;

    public function definition()
    {
        return [
            'name'            => $this->faker->company . ' Residency',
            'builder'         => $this->faker->company,
            'city'            => $this->faker->city,
            'location'        => $this->faker->address,
            'min_price'       => $this->faker->numberBetween(3000000, 5000000),
            'max_price'       => $this->faker->numberBetween(6000000, 12000000),
            'approval_code'   => 'RERA-' . $this->faker->unique()->randomNumber(4),
            'configurations'  => '2, 3, 4 BHK Apartments',
            'possession_date' => $this->faker->dateTimeBetween('now', '+2 years'),
            'status'          => $this->faker->randomElement(['Ready To Move', 'Under Construction']),
            'overview'        => $this->faker->paragraph(2),
            'specifications'  => $this->faker->paragraph(1),
            'brochure_url'    => $this->faker->url,
            'latitude'        => $this->faker->latitude,
            'longitude'       => $this->faker->longitude,
            'contact_phone'   => $this->faker->phoneNumber,
        ];
    }
}

