<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Property extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'title',
        'description',
        'price',
        'address',
        'city',
        'state',
        'zip_code',
        'status', // 'for_sale' or 'for_rent'
        'bedrooms',
        'bathrooms',
        'area_sqft',
    ];

    /**
     * Get the user (builder) that owns the property.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    
    public function images()
	{
	    return $this->hasMany(PropertyImage::class);
	}

	public function comments()
	{
	    return $this->hasMany(Comment::class);
	}

	public function amenities()
	{
	    return $this->hasMany(PropertyAmenity::class);
	}

}
