<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Project extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'name', 'builder', 'city', 'location', 'min_price', 'max_price',
        'approval_code', 'configurations', 'possession_date', 'status', 'is_featured',
        'overview', 'specifications', 'brochure_url', 'latitude', 'longitude', 'contact_phone'
    ];

    public function images() {
        return $this->hasMany(ProjectImage::class);
    }
    public function floorPlans() {
        return $this->hasMany(ProjectFloorPlan::class);
    }
    public function amenities() {
        return $this->hasMany(ProjectAmenity::class);
    }
    public function reviews() {
        return $this->hasMany(ProjectReview::class);
    }
    public function trends() {
        return $this->hasMany(ProjectTrend::class);
    }
}

