<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RoleRedirect
{
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $role = Auth::user()->role;

            if ($role === 'admin') {
                return redirect()->route('admin.dashboard');
            } elseif ($role === 'builder') {
                return redirect()->route('builder.dashboard');
            }else{
                return redirect()->route('user.dashboard');
            }
        }

        // If the user is a regular 'user' or a guest, let them proceed
        return $next($request);
    }
}