<?php

namespace App\Http\Controllers;

use App\Models\Property;
use Illuminate\Http\Request;

class PropertyController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $property = \App\Models\Property::findOrFail($id);
        return view('property.show', compact('property'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    
    public function search(Request $request)
    {
        $query = Property::query();

        // Filter by property type if provided
        if ($request->filled('property_type')) {
            $query->where('type', $request->property_type);
        }

        // Filter by city if provided
        if ($request->filled('city')) {
            $query->where('city', $request->city);
        }

        // Search in title, address, or location fields
        if ($request->filled('q')) {
            $searchTerm = $request->q;
            $query->where(function($q) use ($searchTerm) {
                $q->where('title', 'like', '%' . $searchTerm . '%')
                  ->orWhere('address', 'like', '%' . $searchTerm . '%')
                  ->orWhere('description', 'like', '%' . $searchTerm . '%');
            });
        }

        // Order and paginate results (12 per page)
        $properties = $query->orderBy('created_at', 'desc')->paginate(12);

        return view('property.search', [
            'properties' => $properties,
            'filters' => $request->only(['property_type', 'city', 'q']),
        ]);
    }
    
    public function projectsIndex(Request $request) {
	    $query = Property::where('status', 'builder_property');

        // Example filters—adapt to match your fields!
        if ($request->filled('city')) $query->where('city', $request->city);
        if ($request->filled('status')) $query->where('status', $request->status);
        if ($request->filled('builder')) $query->where('builder', 'like', '%' . $request->builder . '%');
        if ($request->filled('config')) $query->where('configurations', 'like', "%{$request->config}%");
        if ($request->filled('possession_year')) $query->whereYear('possession_date', $request->possession_year);

        $total_projects = $query->count();
        $projects = $query->orderBy('created_at', 'desc')->paginate(20);

        if ($request->ajax()) {
            return view('property.partials.project_list', compact('projects', 'total_projects'))->render();
        }

        return view('property.projects', compact('projects', 'total_projects'));
	}

	public function rentIndex(Request $request)
	{
	    $query = Property::where('type', 'rent');
	    if ($request->filled('bhk_type')) $query->where('bedrooms', $request->bhk_type);
	    if ($request->filled('price_range')) {
		$parts = explode('-', $request->price_range);
		if (count($parts) == 2) $query->whereBetween('price', [$parts[0], $parts[1]]);
	    }
	    if ($request->filled('furnishing')) $query->where('furnishing', $request->furnishing);
	    if ($request->filled('property_type')) $query->where('property_type', $request->property_type);
	    $total_properties = $query->count();
	    $properties = $query->orderBy('created_at', 'desc')->paginate(20);

	    // If AJAX: return partial view
	    if ($request->ajax()) {
		return view('property.partials.rent_list', compact('properties', 'total_properties'))->render();
	    }

	    // Otherwise, full page
	    return view('property.rent', compact('properties', 'total_properties'));
	}

	public function saleIndex(Request $request) {
	    $query = Property::where('type', 'buy');
	    if ($request->filled('bhk_type')) $query->where('bedrooms', $request->bhk_type);
	    if ($request->filled('price_range')) {
		$parts = explode('-', $request->price_range);
		if (count($parts) == 2) $query->whereBetween('price', [$parts[0], $parts[1]]);
	    }
	    if ($request->filled('furnishing')) $query->where('furnishing', $request->furnishing);
	    if ($request->filled('property_type')) $query->where('property_type', $request->property_type);
	    $total_properties = $query->count();
	    $properties = $query->orderBy('created_at', 'desc')->paginate(20);

	    if ($request->ajax()) {
		return view('property.partials.sale_list', compact('properties', 'total_properties'))->render();
	    }

	    return view('property.sale', compact('properties', 'total_properties'));
	}
}
