<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Property;
use App\Models\Project;

class HomeController extends Controller
{
    public function index()
    {
        $projects = Project::orderByDesc('is_featured') // assuming you have an is_featured boolean/int column
	    ->limit(3)
	    ->get();
        $rentProperties = Property::where('status', 'for_rent')->orderByDesc('created_at')->take(4)->get();
        $saleProperties = Property::where('status', 'for_sale')->orderByDesc('created_at')->take(4)->get();
        $latestProjects = Project::orderByDesc('created_at')->limit(3)->get();

        return view('welcome', compact('projects', 'rentProperties', 'saleProperties', 'latestProjects'));
    }
}

